<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierAircraftTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Carrier defined internal grouping of aircrafts with the same form, function and specification.
 * @subpackage Structs
 */
class CarrierAircraftTypeType extends AbstractStructBase
{
    /**
     * The CarrierAircraftTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Internal code used by an carrier to identify the type of aircraft. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierAircraftTypeCode;
    /**
     * The CarrierAircraftTypeName
     * Meta information extracted from the WSDL
     * - documentation: Internal name given by the carrier to this aircraft type. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierAircraftTypeName;
    /**
     * Constructor method for CarrierAircraftTypeType
     * @uses CarrierAircraftTypeType::setCarrierAircraftTypeCode()
     * @uses CarrierAircraftTypeType::setCarrierAircraftTypeName()
     * @param string $carrierAircraftTypeCode
     * @param string $carrierAircraftTypeName
     */
    public function __construct($carrierAircraftTypeCode = null, $carrierAircraftTypeName = null)
    {
        $this
            ->setCarrierAircraftTypeCode($carrierAircraftTypeCode)
            ->setCarrierAircraftTypeName($carrierAircraftTypeName);
    }
    /**
     * Get CarrierAircraftTypeCode value
     * @return string|null
     */
    public function getCarrierAircraftTypeCode()
    {
        return $this->CarrierAircraftTypeCode;
    }
    /**
     * Set CarrierAircraftTypeCode value
     * @param string $carrierAircraftTypeCode
     * @return \StructType\CarrierAircraftTypeType
     */
    public function setCarrierAircraftTypeCode($carrierAircraftTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierAircraftTypeCode) && !is_string($carrierAircraftTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierAircraftTypeCode, true), gettype($carrierAircraftTypeCode)), __LINE__);
        }
        $this->CarrierAircraftTypeCode = $carrierAircraftTypeCode;
        return $this;
    }
    /**
     * Get CarrierAircraftTypeName value
     * @return string|null
     */
    public function getCarrierAircraftTypeName()
    {
        return $this->CarrierAircraftTypeName;
    }
    /**
     * Set CarrierAircraftTypeName value
     * @param string $carrierAircraftTypeName
     * @return \StructType\CarrierAircraftTypeType
     */
    public function setCarrierAircraftTypeName($carrierAircraftTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierAircraftTypeName) && !is_string($carrierAircraftTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierAircraftTypeName, true), gettype($carrierAircraftTypeName)), __LINE__);
        }
        $this->CarrierAircraftTypeName = $carrierAircraftTypeName;
        return $this;
    }
}
