<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalendarDateCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Requests the airline to additionally include a preview of the Offer price for the same Shopping Criteria for the specified date range.
 * @subpackage Structs
 */
class CalendarDateCriteriaType extends AbstractStructBase
{
    /**
     * The DaysAfterNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of days after the Departure and Arrival dates for which the Calendar Date request should consider. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DaysAfterNumber;
    /**
     * The DaysBeforeNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of days prior to the Departure and Arrival dates for which the Calendar Date request should consider. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DaysBeforeNumber;
    /**
     * Constructor method for CalendarDateCriteriaType
     * @uses CalendarDateCriteriaType::setDaysAfterNumber()
     * @uses CalendarDateCriteriaType::setDaysBeforeNumber()
     * @param float $daysAfterNumber
     * @param float $daysBeforeNumber
     */
    public function __construct($daysAfterNumber = null, $daysBeforeNumber = null)
    {
        $this
            ->setDaysAfterNumber($daysAfterNumber)
            ->setDaysBeforeNumber($daysBeforeNumber);
    }
    /**
     * Get DaysAfterNumber value
     * @return float|null
     */
    public function getDaysAfterNumber()
    {
        return $this->DaysAfterNumber;
    }
    /**
     * Set DaysAfterNumber value
     * @param float $daysAfterNumber
     * @return \StructType\CalendarDateCriteriaType
     */
    public function setDaysAfterNumber($daysAfterNumber = null)
    {
        // validation for constraint: float
        if (!is_null($daysAfterNumber) && !(is_float($daysAfterNumber) || is_numeric($daysAfterNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($daysAfterNumber, true), gettype($daysAfterNumber)), __LINE__);
        }
        $this->DaysAfterNumber = $daysAfterNumber;
        return $this;
    }
    /**
     * Get DaysBeforeNumber value
     * @return float|null
     */
    public function getDaysBeforeNumber()
    {
        return $this->DaysBeforeNumber;
    }
    /**
     * Set DaysBeforeNumber value
     * @param float $daysBeforeNumber
     * @return \StructType\CalendarDateCriteriaType
     */
    public function setDaysBeforeNumber($daysBeforeNumber = null)
    {
        // validation for constraint: float
        if (!is_null($daysBeforeNumber) && !(is_float($daysBeforeNumber) || is_numeric($daysBeforeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($daysBeforeNumber, true), gettype($daysBeforeNumber)), __LINE__);
        }
        $this->DaysBeforeNumber = $daysBeforeNumber;
        return $this;
    }
}
