<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinTypeListType StructType
 * Meta information extracted from the WSDL
 * - documentation: List of Cabin Types Technical object only
 * @subpackage Structs
 */
class CabinTypeListType extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\CabinTypeType[]
     */
    public $CabinType;
    /**
     * Constructor method for CabinTypeListType
     * @uses CabinTypeListType::setCabinType()
     * @param \StructType\CabinTypeType[] $cabinType
     */
    public function __construct(array $cabinType = array())
    {
        $this
            ->setCabinType($cabinType);
    }
    /**
     * Get CabinType value
     * @return \StructType\CabinTypeType[]
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinTypeForArrayConstraintsFromSetCabinType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinTypeListTypeCabinTypeItem) {
            // validation for constraint: itemType
            if (!$cabinTypeListTypeCabinTypeItem instanceof \StructType\CabinTypeType) {
                $invalidValues[] = is_object($cabinTypeListTypeCabinTypeItem) ? get_class($cabinTypeListTypeCabinTypeItem) : sprintf('%s(%s)', gettype($cabinTypeListTypeCabinTypeItem), var_export($cabinTypeListTypeCabinTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinType property can only contain items of type \StructType\CabinTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeType[] $cabinType
     * @return \StructType\CabinTypeListType
     */
    public function setCabinType(array $cabinType = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinTypeArrayErrorMessage = self::validateCabinTypeForArrayConstraintsFromSetCabinType($cabinType))) {
            throw new \InvalidArgumentException($cabinTypeArrayErrorMessage, __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Add item to CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinTypeType $item
     * @return \StructType\CabinTypeListType
     */
    public function addToCabinType(\StructType\CabinTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinTypeType) {
            throw new \InvalidArgumentException(sprintf('The CabinType property can only contain items of type \StructType\CabinTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinType[] = $item;
        return $this;
    }
}
