<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinComponentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Non-seat related cabin feature or facility (e.g. lavatory, galley, closet, stowage, etc.) Business Identifier Fields: - [Aircraft Group Configuration] (All identifying fields) - Cabin Component Type Code - Cabin Component Name
 * @subpackage Structs
 */
class CabinComponentType extends AbstractStructBase
{
    /**
     * The CabinComponentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code of the cabin component Type | Cabin component type code set. Examples: 701 (Movable compartment divider) 702 (Convertible seats) AR (Air phone) BA (Bar) BK (Bulkhead) CL (Closet) G (Galley) LA (Lavatory) LG (Luggage storage) MV
     * (Movie screen) SO (Storage space) ST (Stairs to upper deck) TA (Table {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Cabin facilities characteristic{/codeListName} {codeListIdentifier}9978{/codeListIdentifier} | Specifies a Cabin
     * Component Type Code.
     * - base: CabinComponentTypeCodeContentType
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $CabinComponentTypeCode;
    /**
     * The AbsoluteLengthMeasure
     * Meta information extracted from the WSDL
     * - documentation: Length of the component measured along the axis of the aircraft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $AbsoluteLengthMeasure;
    /**
     * The AbsoluteWidthMeasure
     * Meta information extracted from the WSDL
     * - documentation: Width of the component measured along the lateral axis of the aircraft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $AbsoluteWidthMeasure;
    /**
     * The ColumnEquivWidthNumber
     * Meta information extracted from the WSDL
     * - documentation: Equivalent width of the component in columns. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ColumnEquivWidthNumber;
    /**
     * The ColumnID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the column (e.g. A, B, C, etc.). | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ColumnID;
    /**
     * The FirstRowNumber
     * Meta information extracted from the WSDL
     * - documentation: First row number of the Cabin Component. | A mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $FirstRowNumber;
    /**
     * The LastRowNumber
     * Meta information extracted from the WSDL
     * - documentation: Last row number of the Cabin Component. | A mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $LastRowNumber;
    /**
     * The OrientationCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the orientation, or direction of the component. | Cabin component location placement. {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Place/Location Qualifier{/codeListName}
     * {codeListIdentifier}3227{/codeListIdentifier} | Additional BDT to specify the Cabin Component Orientation Code.
     * - base: OrientationCodeContentType
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrientationCode;
    /**
     * The PositionCode
     * Meta information extracted from the WSDL
     * - documentation: Location of the component relative to the associated Seat Row position (e.g. Before or After). | Additional BDT to specify the Cabin Component Position Code (e.g. Before, After).
     * - base: ComponentPositionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PositionCode;
    /**
     * The RowEquivLengthNumber
     * Meta information extracted from the WSDL
     * - documentation: Equivalent length of the component in rows. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $RowEquivLengthNumber;
    /**
     * Constructor method for CabinComponentType
     * @uses CabinComponentType::setCabinComponentTypeCode()
     * @uses CabinComponentType::setAbsoluteLengthMeasure()
     * @uses CabinComponentType::setAbsoluteWidthMeasure()
     * @uses CabinComponentType::setColumnEquivWidthNumber()
     * @uses CabinComponentType::setColumnID()
     * @uses CabinComponentType::setFirstRowNumber()
     * @uses CabinComponentType::setLastRowNumber()
     * @uses CabinComponentType::setOrientationCode()
     * @uses CabinComponentType::setPositionCode()
     * @uses CabinComponentType::setRowEquivLengthNumber()
     * @param string $cabinComponentTypeCode
     * @param \StructType\MeasureType $absoluteLengthMeasure
     * @param \StructType\MeasureType $absoluteWidthMeasure
     * @param float $columnEquivWidthNumber
     * @param string[] $columnID
     * @param int $firstRowNumber
     * @param int $lastRowNumber
     * @param string $orientationCode
     * @param string $positionCode
     * @param float $rowEquivLengthNumber
     */
    public function __construct($cabinComponentTypeCode = null, \StructType\MeasureType $absoluteLengthMeasure = null, \StructType\MeasureType $absoluteWidthMeasure = null, $columnEquivWidthNumber = null, array $columnID = array(), $firstRowNumber = null, $lastRowNumber = null, $orientationCode = null, $positionCode = null, $rowEquivLengthNumber = null)
    {
        $this
            ->setCabinComponentTypeCode($cabinComponentTypeCode)
            ->setAbsoluteLengthMeasure($absoluteLengthMeasure)
            ->setAbsoluteWidthMeasure($absoluteWidthMeasure)
            ->setColumnEquivWidthNumber($columnEquivWidthNumber)
            ->setColumnID($columnID)
            ->setFirstRowNumber($firstRowNumber)
            ->setLastRowNumber($lastRowNumber)
            ->setOrientationCode($orientationCode)
            ->setPositionCode($positionCode)
            ->setRowEquivLengthNumber($rowEquivLengthNumber);
    }
    /**
     * Get CabinComponentTypeCode value
     * @return string
     */
    public function getCabinComponentTypeCode()
    {
        return $this->CabinComponentTypeCode;
    }
    /**
     * Set CabinComponentTypeCode value
     * @param string $cabinComponentTypeCode
     * @return \StructType\CabinComponentType
     */
    public function setCabinComponentTypeCode($cabinComponentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cabinComponentTypeCode) && !is_string($cabinComponentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinComponentTypeCode, true), gettype($cabinComponentTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($cabinComponentTypeCode) && mb_strlen($cabinComponentTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($cabinComponentTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cabinComponentTypeCode) && mb_strlen($cabinComponentTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cabinComponentTypeCode)), __LINE__);
        }
        $this->CabinComponentTypeCode = $cabinComponentTypeCode;
        return $this;
    }
    /**
     * Get AbsoluteLengthMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getAbsoluteLengthMeasure()
    {
        return $this->AbsoluteLengthMeasure;
    }
    /**
     * Set AbsoluteLengthMeasure value
     * @param \StructType\MeasureType $absoluteLengthMeasure
     * @return \StructType\CabinComponentType
     */
    public function setAbsoluteLengthMeasure(\StructType\MeasureType $absoluteLengthMeasure = null)
    {
        $this->AbsoluteLengthMeasure = $absoluteLengthMeasure;
        return $this;
    }
    /**
     * Get AbsoluteWidthMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getAbsoluteWidthMeasure()
    {
        return $this->AbsoluteWidthMeasure;
    }
    /**
     * Set AbsoluteWidthMeasure value
     * @param \StructType\MeasureType $absoluteWidthMeasure
     * @return \StructType\CabinComponentType
     */
    public function setAbsoluteWidthMeasure(\StructType\MeasureType $absoluteWidthMeasure = null)
    {
        $this->AbsoluteWidthMeasure = $absoluteWidthMeasure;
        return $this;
    }
    /**
     * Get ColumnEquivWidthNumber value
     * @return float|null
     */
    public function getColumnEquivWidthNumber()
    {
        return $this->ColumnEquivWidthNumber;
    }
    /**
     * Set ColumnEquivWidthNumber value
     * @param float $columnEquivWidthNumber
     * @return \StructType\CabinComponentType
     */
    public function setColumnEquivWidthNumber($columnEquivWidthNumber = null)
    {
        // validation for constraint: float
        if (!is_null($columnEquivWidthNumber) && !(is_float($columnEquivWidthNumber) || is_numeric($columnEquivWidthNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($columnEquivWidthNumber, true), gettype($columnEquivWidthNumber)), __LINE__);
        }
        $this->ColumnEquivWidthNumber = $columnEquivWidthNumber;
        return $this;
    }
    /**
     * Get ColumnID value
     * @return string[]|null
     */
    public function getColumnID()
    {
        return $this->ColumnID;
    }
    /**
     * This method is responsible for validating the values passed to the setColumnID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColumnID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColumnIDForArrayConstraintsFromSetColumnID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinComponentTypeColumnIDItem) {
            // validation for constraint: itemType
            if (!is_string($cabinComponentTypeColumnIDItem)) {
                $invalidValues[] = is_object($cabinComponentTypeColumnIDItem) ? get_class($cabinComponentTypeColumnIDItem) : sprintf('%s(%s)', gettype($cabinComponentTypeColumnIDItem), var_export($cabinComponentTypeColumnIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ColumnID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ColumnID value
     * @throws \InvalidArgumentException
     * @param string[] $columnID
     * @return \StructType\CabinComponentType
     */
    public function setColumnID(array $columnID = array())
    {
        // validation for constraint: array
        if ('' !== ($columnIDArrayErrorMessage = self::validateColumnIDForArrayConstraintsFromSetColumnID($columnID))) {
            throw new \InvalidArgumentException($columnIDArrayErrorMessage, __LINE__);
        }
        $this->ColumnID = $columnID;
        return $this;
    }
    /**
     * Add item to ColumnID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CabinComponentType
     */
    public function addToColumnID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ColumnID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ColumnID[] = $item;
        return $this;
    }
    /**
     * Get FirstRowNumber value
     * @return int|null
     */
    public function getFirstRowNumber()
    {
        return $this->FirstRowNumber;
    }
    /**
     * Set FirstRowNumber value
     * @param int $firstRowNumber
     * @return \StructType\CabinComponentType
     */
    public function setFirstRowNumber($firstRowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($firstRowNumber) && !(is_int($firstRowNumber) || ctype_digit($firstRowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstRowNumber, true), gettype($firstRowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($firstRowNumber) && $firstRowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($firstRowNumber, true)), __LINE__);
        }
        $this->FirstRowNumber = $firstRowNumber;
        return $this;
    }
    /**
     * Get LastRowNumber value
     * @return int|null
     */
    public function getLastRowNumber()
    {
        return $this->LastRowNumber;
    }
    /**
     * Set LastRowNumber value
     * @param int $lastRowNumber
     * @return \StructType\CabinComponentType
     */
    public function setLastRowNumber($lastRowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lastRowNumber) && !(is_int($lastRowNumber) || ctype_digit($lastRowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastRowNumber, true), gettype($lastRowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lastRowNumber) && $lastRowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lastRowNumber, true)), __LINE__);
        }
        $this->LastRowNumber = $lastRowNumber;
        return $this;
    }
    /**
     * Get OrientationCode value
     * @return string|null
     */
    public function getOrientationCode()
    {
        return $this->OrientationCode;
    }
    /**
     * Set OrientationCode value
     * @param string $orientationCode
     * @return \StructType\CabinComponentType
     */
    public function setOrientationCode($orientationCode = null)
    {
        // validation for constraint: string
        if (!is_null($orientationCode) && !is_string($orientationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orientationCode, true), gettype($orientationCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($orientationCode) && mb_strlen($orientationCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($orientationCode)), __LINE__);
        }
        $this->OrientationCode = $orientationCode;
        return $this;
    }
    /**
     * Get PositionCode value
     * @return string|null
     */
    public function getPositionCode()
    {
        return $this->PositionCode;
    }
    /**
     * Set PositionCode value
     * @param string $positionCode
     * @return \StructType\CabinComponentType
     */
    public function setPositionCode($positionCode = null)
    {
        // validation for constraint: string
        if (!is_null($positionCode) && !is_string($positionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionCode, true), gettype($positionCode)), __LINE__);
        }
        $this->PositionCode = $positionCode;
        return $this;
    }
    /**
     * Get RowEquivLengthNumber value
     * @return float|null
     */
    public function getRowEquivLengthNumber()
    {
        return $this->RowEquivLengthNumber;
    }
    /**
     * Set RowEquivLengthNumber value
     * @param float $rowEquivLengthNumber
     * @return \StructType\CabinComponentType
     */
    public function setRowEquivLengthNumber($rowEquivLengthNumber = null)
    {
        // validation for constraint: float
        if (!is_null($rowEquivLengthNumber) && !(is_float($rowEquivLengthNumber) || is_numeric($rowEquivLengthNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rowEquivLengthNumber, true), gettype($rowEquivLengthNumber)), __LINE__);
        }
        $this->RowEquivLengthNumber = $rowEquivLengthNumber;
        return $this;
    }
}
