<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingEntityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Booking entity Information related to a booking or reservation.
 * @subpackage Structs
 */
class BookingEntityType extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - choice: Carrier | Org
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CarrierType
     */
    public $Carrier;
    /**
     * The Org
     * Meta information extracted from the WSDL
     * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - choice: Carrier | Org
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrgType
     */
    public $Org;
    /**
     * Constructor method for BookingEntityType
     * @uses BookingEntityType::setCarrier()
     * @uses BookingEntityType::setOrg()
     * @param \StructType\CarrierType $carrier
     * @param \StructType\OrgType $org
     */
    public function __construct(\StructType\CarrierType $carrier = null, \StructType\OrgType $org = null)
    {
        $this
            ->setCarrier($carrier)
            ->setOrg($org);
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType
     */
    public function getCarrier()
    {
        return isset($this->Carrier) ? $this->Carrier : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCarrier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrier method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCarrierForChoiceConstraintsFromSetCarrier($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Org',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Carrier can\'t be set as the property %s is already set. Only one property must be set among these properties: Carrier, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Carrier value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierType $carrier
     * @return \StructType\BookingEntityType
     */
    public function setCarrier(\StructType\CarrierType $carrier = null)
    {
        // validation for constraint: choice(Carrier, Org)
        if ('' !== ($carrierChoiceErrorMessage = self::validateCarrierForChoiceConstraintsFromSetCarrier($carrier))) {
            throw new \InvalidArgumentException($carrierChoiceErrorMessage, __LINE__);
        }
        if (is_null($carrier) || (is_array($carrier) && empty($carrier))) {
            unset($this->Carrier);
        } else {
            $this->Carrier = $carrier;
        }
        return $this;
    }
    /**
     * Get Org value
     * @return \StructType\OrgType
     */
    public function getOrg()
    {
        return isset($this->Org) ? $this->Org : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrg method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrgForChoiceConstraintsFromSetOrg($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Carrier',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Org can\'t be set as the property %s is already set. Only one property must be set among these properties: Org, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Org value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrgType $org
     * @return \StructType\BookingEntityType
     */
    public function setOrg(\StructType\OrgType $org = null)
    {
        // validation for constraint: choice(Carrier, Org)
        if ('' !== ($orgChoiceErrorMessage = self::validateOrgForChoiceConstraintsFromSetOrg($org))) {
            throw new \InvalidArgumentException($orgChoiceErrorMessage, __LINE__);
        }
        if (is_null($org) || (is_array($org) && empty($org))) {
            unset($this->Org);
        } else {
            $this->Org = $org;
        }
        return $this;
    }
}
