<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BilateralTimeLimitType StructType
 * Meta information extracted from the WSDL
 * - documentation: A bilaterally agreed limitation or restriction of time.
 * @subpackage Structs
 */
class BilateralTimeLimitType extends AbstractStructBase
{
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Additional text to supplement a specified time limit. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Bilaterally-agreed time limit name. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The TimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: Date and time of the time limit. E.g. 2017-05-30T09:00:00 | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeLimitDateTime;
    /**
     * Constructor method for BilateralTimeLimitType
     * @uses BilateralTimeLimitType::setDescText()
     * @uses BilateralTimeLimitType::setName()
     * @uses BilateralTimeLimitType::setTimeLimitDateTime()
     * @param string $descText
     * @param string $name
     * @param string $timeLimitDateTime
     */
    public function __construct($descText = null, $name = null, $timeLimitDateTime = null)
    {
        $this
            ->setDescText($descText)
            ->setName($name)
            ->setTimeLimitDateTime($timeLimitDateTime);
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\BilateralTimeLimitType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BilateralTimeLimitType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get TimeLimitDateTime value
     * @return string|null
     */
    public function getTimeLimitDateTime()
    {
        return $this->TimeLimitDateTime;
    }
    /**
     * Set TimeLimitDateTime value
     * @param string $timeLimitDateTime
     * @return \StructType\BilateralTimeLimitType
     */
    public function setTimeLimitDateTime($timeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($timeLimitDateTime) && !is_string($timeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeLimitDateTime, true), gettype($timeLimitDateTime)), __LINE__);
        }
        $this->TimeLimitDateTime = $timeLimitDateTime;
        return $this;
    }
}
