<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage service information used for long sells.
 * @subpackage Structs
 */
class BaggageItemType extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Segment within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentRefID;
    /**
     * The BagItemDetails
     * Meta information extracted from the WSDL
     * - documentation: Additional disclosure and allowance information for Bag Items used in Long Sells.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BagItemDetailsType[]
     */
    public $BagItemDetails;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The ValidatingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes. Example: UA, BA Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code | The codelist
     * contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution
     * 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined
     * 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $ValidatingCarrierCode;
    /**
     * Constructor method for BaggageItemType
     * @uses BaggageItemType::setPaxRefID()
     * @uses BaggageItemType::setPaxSegmentRefID()
     * @uses BaggageItemType::setBagItemDetails()
     * @uses BaggageItemType::setPrice()
     * @uses BaggageItemType::setValidatingCarrierCode()
     * @param string $paxRefID
     * @param string $paxSegmentRefID
     * @param \StructType\BagItemDetailsType[] $bagItemDetails
     * @param \StructType\PriceType $price
     * @param string $validatingCarrierCode
     */
    public function __construct($paxRefID = null, $paxSegmentRefID = null, array $bagItemDetails = array(), \StructType\PriceType $price = null, $validatingCarrierCode = null)
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setBagItemDetails($bagItemDetails)
            ->setPrice($price)
            ->setValidatingCarrierCode($validatingCarrierCode);
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\BaggageItemType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * Set PaxSegmentRefID value
     * @param string $paxSegmentRefID
     * @return \StructType\BaggageItemType
     */
    public function setPaxSegmentRefID($paxSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentRefID) && !is_string($paxSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentRefID, true), gettype($paxSegmentRefID)), __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Get BagItemDetails value
     * @return \StructType\BagItemDetailsType[]|null
     */
    public function getBagItemDetails()
    {
        return $this->BagItemDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setBagItemDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBagItemDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBagItemDetailsForArrayConstraintsFromSetBagItemDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageItemTypeBagItemDetailsItem) {
            // validation for constraint: itemType
            if (!$baggageItemTypeBagItemDetailsItem instanceof \StructType\BagItemDetailsType) {
                $invalidValues[] = is_object($baggageItemTypeBagItemDetailsItem) ? get_class($baggageItemTypeBagItemDetailsItem) : sprintf('%s(%s)', gettype($baggageItemTypeBagItemDetailsItem), var_export($baggageItemTypeBagItemDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BagItemDetails property can only contain items of type \StructType\BagItemDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BagItemDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\BagItemDetailsType[] $bagItemDetails
     * @return \StructType\BaggageItemType
     */
    public function setBagItemDetails(array $bagItemDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($bagItemDetailsArrayErrorMessage = self::validateBagItemDetailsForArrayConstraintsFromSetBagItemDetails($bagItemDetails))) {
            throw new \InvalidArgumentException($bagItemDetailsArrayErrorMessage, __LINE__);
        }
        $this->BagItemDetails = $bagItemDetails;
        return $this;
    }
    /**
     * Add item to BagItemDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\BagItemDetailsType $item
     * @return \StructType\BaggageItemType
     */
    public function addToBagItemDetails(\StructType\BagItemDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BagItemDetailsType) {
            throw new \InvalidArgumentException(sprintf('The BagItemDetails property can only contain items of type \StructType\BagItemDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BagItemDetails[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\BaggageItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get ValidatingCarrierCode value
     * @return string|null
     */
    public function getValidatingCarrierCode()
    {
        return $this->ValidatingCarrierCode;
    }
    /**
     * Set ValidatingCarrierCode value
     * @param string $validatingCarrierCode
     * @return \StructType\BaggageItemType
     */
    public function setValidatingCarrierCode($validatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrierCode) && !is_string($validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingCarrierCode, true), gettype($validatingCarrierCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($validatingCarrierCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $validatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($validatingCarrierCode, true)), __LINE__);
        }
        $this->ValidatingCarrierCode = $validatingCarrierCode;
        return $this;
    }
}
