<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAllowanceRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to a Baggage Allowance
 * @subpackage Structs
 */
class BaggageAllowanceRefType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Bag Allowance ID within this message. If there are multiple Allowance ID's, then this should be treated as choice and one baggage item as defined in the referred baggage allowance element can be selected. | An
     * identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $BaggageAllowanceRefID;
    /**
     * Constructor method for BaggageAllowanceRefType
     * @uses BaggageAllowanceRefType::setBaggageAllowanceRefID()
     * @param string[] $baggageAllowanceRefID
     */
    public function __construct(array $baggageAllowanceRefID = array())
    {
        $this
            ->setBaggageAllowanceRefID($baggageAllowanceRefID);
    }
    /**
     * Get BaggageAllowanceRefID value
     * @return string[]
     */
    public function getBaggageAllowanceRefID()
    {
        return $this->BaggageAllowanceRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageAllowanceRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAllowanceRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAllowanceRefTypeBaggageAllowanceRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($baggageAllowanceRefTypeBaggageAllowanceRefIDItem)) {
                $invalidValues[] = is_object($baggageAllowanceRefTypeBaggageAllowanceRefIDItem) ? get_class($baggageAllowanceRefTypeBaggageAllowanceRefIDItem) : sprintf('%s(%s)', gettype($baggageAllowanceRefTypeBaggageAllowanceRefIDItem), var_export($baggageAllowanceRefTypeBaggageAllowanceRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string[] $baggageAllowanceRefID
     * @return \StructType\BaggageAllowanceRefType
     */
    public function setBaggageAllowanceRefID(array $baggageAllowanceRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageAllowanceRefIDArrayErrorMessage = self::validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID($baggageAllowanceRefID))) {
            throw new \InvalidArgumentException($baggageAllowanceRefIDArrayErrorMessage, __LINE__);
        }
        $this->BaggageAllowanceRefID = $baggageAllowanceRefID;
        return $this;
    }
    /**
     * Add item to BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BaggageAllowanceRefType
     */
    public function addToBaggageAllowanceRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageAllowanceRefID[] = $item;
        return $this;
    }
}
