<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAllowanceListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage allowance data list definition
 * @subpackage Structs
 */
class BaggageAllowanceListType extends AbstractStructBase
{
    /**
     * The BaggageAllowance
     * Meta information extracted from the WSDL
     * - documentation: The amount of checked or carry-on luggage the airline will allow per passenger.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\BaggageAllowanceType[]
     */
    public $BaggageAllowance;
    /**
     * Constructor method for BaggageAllowanceListType
     * @uses BaggageAllowanceListType::setBaggageAllowance()
     * @param \StructType\BaggageAllowanceType[] $baggageAllowance
     */
    public function __construct(array $baggageAllowance = array())
    {
        $this
            ->setBaggageAllowance($baggageAllowance);
    }
    /**
     * Get BaggageAllowance value
     * @return \StructType\BaggageAllowanceType[]
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageAllowance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAllowance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageAllowanceForArrayConstraintsFromSetBaggageAllowance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAllowanceListTypeBaggageAllowanceItem) {
            // validation for constraint: itemType
            if (!$baggageAllowanceListTypeBaggageAllowanceItem instanceof \StructType\BaggageAllowanceType) {
                $invalidValues[] = is_object($baggageAllowanceListTypeBaggageAllowanceItem) ? get_class($baggageAllowanceListTypeBaggageAllowanceItem) : sprintf('%s(%s)', gettype($baggageAllowanceListTypeBaggageAllowanceItem), var_export($baggageAllowanceListTypeBaggageAllowanceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageAllowance property can only contain items of type \StructType\BaggageAllowanceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageAllowanceType[] $baggageAllowance
     * @return \StructType\BaggageAllowanceListType
     */
    public function setBaggageAllowance(array $baggageAllowance = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageAllowanceArrayErrorMessage = self::validateBaggageAllowanceForArrayConstraintsFromSetBaggageAllowance($baggageAllowance))) {
            throw new \InvalidArgumentException($baggageAllowanceArrayErrorMessage, __LINE__);
        }
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Add item to BaggageAllowance value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageAllowanceType $item
     * @return \StructType\BaggageAllowanceListType
     */
    public function addToBaggageAllowance(\StructType\BaggageAllowanceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaggageAllowanceType) {
            throw new \InvalidArgumentException(sprintf('The BaggageAllowance property can only contain items of type \StructType\BaggageAllowanceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageAllowance[] = $item;
        return $this;
    }
}
