<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagDimensionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A measurable extent of a particular bag, such as length, or height.
 * @subpackage Structs
 */
class BagDimensionType extends AbstractStructBase
{
    /**
     * The HeightMeasure
     * Meta information extracted from the WSDL
     * - documentation: A measurement of someone or something from head to foot or from base to top. Measure. Unit. Code must be CMT (centimeters). | A numeric value determining a length (linear dimension) along with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $HeightMeasure;
    /**
     * The LengthMeasure
     * Meta information extracted from the WSDL
     * - documentation: A measurement or extent of something from end to end; the greater of two or the greatest of three dimensions of an object. Measure. Unit. Code must be CMT (centimeters). | A numeric value determining a length (linear dimension) along
     * with the specified unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $LengthMeasure;
    /**
     * The WidthMeasure
     * Meta information extracted from the WSDL
     * - documentation: A measurement or extent of the bag from side to side; the lesser of two or the least of three dimensions of the bag. Unit must be CMT (centimeters). | A numeric value determining a length (linear dimension) along with the specified
     * unit of measure.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $WidthMeasure;
    /**
     * Constructor method for BagDimensionType
     * @uses BagDimensionType::setHeightMeasure()
     * @uses BagDimensionType::setLengthMeasure()
     * @uses BagDimensionType::setWidthMeasure()
     * @param float $heightMeasure
     * @param float $lengthMeasure
     * @param float $widthMeasure
     */
    public function __construct($heightMeasure = null, $lengthMeasure = null, $widthMeasure = null)
    {
        $this
            ->setHeightMeasure($heightMeasure)
            ->setLengthMeasure($lengthMeasure)
            ->setWidthMeasure($widthMeasure);
    }
    /**
     * Get HeightMeasure value
     * @return float|null
     */
    public function getHeightMeasure()
    {
        return $this->HeightMeasure;
    }
    /**
     * Set HeightMeasure value
     * @param float $heightMeasure
     * @return \StructType\BagDimensionType
     */
    public function setHeightMeasure($heightMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($heightMeasure) && !(is_float($heightMeasure) || is_numeric($heightMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($heightMeasure, true), gettype($heightMeasure)), __LINE__);
        }
        $this->HeightMeasure = $heightMeasure;
        return $this;
    }
    /**
     * Get LengthMeasure value
     * @return float|null
     */
    public function getLengthMeasure()
    {
        return $this->LengthMeasure;
    }
    /**
     * Set LengthMeasure value
     * @param float $lengthMeasure
     * @return \StructType\BagDimensionType
     */
    public function setLengthMeasure($lengthMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($lengthMeasure) && !(is_float($lengthMeasure) || is_numeric($lengthMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lengthMeasure, true), gettype($lengthMeasure)), __LINE__);
        }
        $this->LengthMeasure = $lengthMeasure;
        return $this;
    }
    /**
     * Get WidthMeasure value
     * @return float|null
     */
    public function getWidthMeasure()
    {
        return $this->WidthMeasure;
    }
    /**
     * Set WidthMeasure value
     * @param float $widthMeasure
     * @return \StructType\BagDimensionType
     */
    public function setWidthMeasure($widthMeasure = null)
    {
        // validation for constraint: float
        if (!is_null($widthMeasure) && !(is_float($widthMeasure) || is_numeric($widthMeasure))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($widthMeasure, true), gettype($widthMeasure)), __LINE__);
        }
        $this->WidthMeasure = $widthMeasure;
        return $this;
    }
}
