<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AugmentationPointType StructType
 * Meta information extracted from the WSDL
 * - documentation: Implementer-Augmented Structure.
 * @subpackage Structs
 */
class AugmentationPointType extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The AugPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AugPoint[]
     */
    public $AugPoint;
    /**
     * Constructor method for AugmentationPointType
     * @uses AugmentationPointType::setAny()
     * @uses AugmentationPointType::setAugPoint()
     * @param \DOMDocument $any
     * @param \StructType\AugPoint[] $augPoint
     */
    public function __construct(\DOMDocument $any = null, array $augPoint = array())
    {
        $this
            ->setAny($any)
            ->setAugPoint($augPoint);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\AugmentationPointType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get AugPoint value
     * @return \StructType\AugPoint[]|null
     */
    public function getAugPoint()
    {
        return $this->AugPoint;
    }
    /**
     * This method is responsible for validating the values passed to the setAugPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAugPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAugPointForArrayConstraintsFromSetAugPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $augmentationPointTypeAugPointItem) {
            // validation for constraint: itemType
            if (!$augmentationPointTypeAugPointItem instanceof \StructType\AugPoint) {
                $invalidValues[] = is_object($augmentationPointTypeAugPointItem) ? get_class($augmentationPointTypeAugPointItem) : sprintf('%s(%s)', gettype($augmentationPointTypeAugPointItem), var_export($augmentationPointTypeAugPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AugPoint property can only contain items of type \StructType\AugPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AugPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\AugPoint[] $augPoint
     * @return \StructType\AugmentationPointType
     */
    public function setAugPoint(array $augPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($augPointArrayErrorMessage = self::validateAugPointForArrayConstraintsFromSetAugPoint($augPoint))) {
            throw new \InvalidArgumentException($augPointArrayErrorMessage, __LINE__);
        }
        $this->AugPoint = $augPoint;
        return $this;
    }
    /**
     * Add item to AugPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\AugPoint $item
     * @return \StructType\AugmentationPointType
     */
    public function addToAugPoint(\StructType\AugPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AugPoint) {
            throw new \InvalidArgumentException(sprintf('The AugPoint property can only contain items of type \StructType\AugPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AugPoint[] = $item;
        return $this;
    }
}
