<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrivalFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight arrival information.
 * @subpackage Structs
 */
class ArrivalFilterCriteriaType extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - documentation: Arrival date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The StationCode
     * Meta information extracted from the WSDL
     * - documentation: Arrival station/airport. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StationCode;
    /**
     * Constructor method for ArrivalFilterCriteriaType
     * @uses ArrivalFilterCriteriaType::setArrivalDate()
     * @uses ArrivalFilterCriteriaType::setStationCode()
     * @param string $arrivalDate
     * @param string $stationCode
     */
    public function __construct($arrivalDate = null, $stationCode = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setStationCode($stationCode);
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\ArrivalFilterCriteriaType
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \StructType\ArrivalFilterCriteriaType
     */
    public function setStationCode($stationCode = null)
    {
        // validation for constraint: string
        if (!is_null($stationCode) && !is_string($stationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationCode, true), gettype($stationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($stationCode) && mb_strlen($stationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($stationCode)), __LINE__);
        }
        $this->StationCode = $stationCode;
        return $this;
    }
}
