<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllianceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
 * @subpackage Structs
 */
class AllianceType extends AbstractStructBase
{
    /**
     * The AllianceCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the alliance based on PADIS Code List (code list defined in BDT). | Enumeration set for the Alliance Code BDT. {codeListAgencyName}ATSB Codeset{/codeListAgencyName} {codeListName}PADIS 9906{/codeListName} | Additional
     * BDT to specify alliance codes.
     * - base: AllianceCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AllianceCode;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CarrierType[]
     */
    public $Carrier;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Alliance name. Example: One World Alliance | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Alliance information URL. Example: http://www.oneworld.com/home | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World
     * Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for AllianceType
     * @uses AllianceType::setAllianceCode()
     * @uses AllianceType::setCarrier()
     * @uses AllianceType::setName()
     * @uses AllianceType::setURL()
     * @param string $allianceCode
     * @param \StructType\CarrierType[] $carrier
     * @param string $name
     * @param string $uRL
     */
    public function __construct($allianceCode = null, array $carrier = array(), $name = null, $uRL = null)
    {
        $this
            ->setAllianceCode($allianceCode)
            ->setCarrier($carrier)
            ->setName($name)
            ->setURL($uRL);
    }
    /**
     * Get AllianceCode value
     * @return string
     */
    public function getAllianceCode()
    {
        return $this->AllianceCode;
    }
    /**
     * Set AllianceCode value
     * @param string $allianceCode
     * @return \StructType\AllianceType
     */
    public function setAllianceCode($allianceCode = null)
    {
        // validation for constraint: string
        if (!is_null($allianceCode) && !is_string($allianceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceCode, true), gettype($allianceCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($allianceCode) && mb_strlen($allianceCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($allianceCode)), __LINE__);
        }
        $this->AllianceCode = $allianceCode;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType[]|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierForArrayConstraintsFromSetCarrier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allianceTypeCarrierItem) {
            // validation for constraint: itemType
            if (!$allianceTypeCarrierItem instanceof \StructType\CarrierType) {
                $invalidValues[] = is_object($allianceTypeCarrierItem) ? get_class($allianceTypeCarrierItem) : sprintf('%s(%s)', gettype($allianceTypeCarrierItem), var_export($allianceTypeCarrierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Carrier property can only contain items of type \StructType\CarrierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Carrier value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierType[] $carrier
     * @return \StructType\AllianceType
     */
    public function setCarrier(array $carrier = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierArrayErrorMessage = self::validateCarrierForArrayConstraintsFromSetCarrier($carrier))) {
            throw new \InvalidArgumentException($carrierArrayErrorMessage, __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Add item to Carrier value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierType $item
     * @return \StructType\AllianceType
     */
    public function addToCarrier(\StructType\CarrierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarrierType) {
            throw new \InvalidArgumentException(sprintf('The Carrier property can only contain items of type \StructType\CarrierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Carrier[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AllianceType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\AllianceType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
