<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineTaxonomyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
 * see the implementation guide at: https://guides.developer.iata.org
 * @subpackage Structs
 */
class AirlineTaxonomyType extends AbstractStructBase
{
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: To enable the Airline to describe the Taxonomy without the need for the Seller to refer to a specifc Taxonomy optionally. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The TaxonomyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for defining a product or service within the Shared Industry Taxonomy or bilaterally. | The code for a product or service within the Shared Industry Taxonomy or bilaterally. Refer to EASD Codeset
     * https://guides.developer.iata.org | A code defining a product or service within the Shared Industry Taxonomy or bilaterally. Refer to EASD Codeset https://guides.developer.iata.org
     * - base: TaxonomyCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxonomyCode;
    /**
     * The TaxonomyFeature
     * Meta information extracted from the WSDL
     * - documentation: Bilaterally agreed mechanism to describe specific product and service information to the Seller as defined by the Airline. This defines a further level of definition for a airline taxonomy code. e.g meal (TC 03F0) -> breakfast(03F1)
     * - eggs(03F2),toast(03F3)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxonomyFeatureType[]
     */
    public $TaxonomyFeature;
    /**
     * Constructor method for AirlineTaxonomyType
     * @uses AirlineTaxonomyType::setDescText()
     * @uses AirlineTaxonomyType::setTaxonomyCode()
     * @uses AirlineTaxonomyType::setTaxonomyFeature()
     * @param string $descText
     * @param string $taxonomyCode
     * @param \StructType\TaxonomyFeatureType[] $taxonomyFeature
     */
    public function __construct($descText = null, $taxonomyCode = null, array $taxonomyFeature = array())
    {
        $this
            ->setDescText($descText)
            ->setTaxonomyCode($taxonomyCode)
            ->setTaxonomyFeature($taxonomyFeature);
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\AirlineTaxonomyType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get TaxonomyCode value
     * @return string|null
     */
    public function getTaxonomyCode()
    {
        return $this->TaxonomyCode;
    }
    /**
     * Set TaxonomyCode value
     * @param string $taxonomyCode
     * @return \StructType\AirlineTaxonomyType
     */
    public function setTaxonomyCode($taxonomyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxonomyCode) && !is_string($taxonomyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxonomyCode, true), gettype($taxonomyCode)), __LINE__);
        }
        $this->TaxonomyCode = $taxonomyCode;
        return $this;
    }
    /**
     * Get TaxonomyFeature value
     * @return \StructType\TaxonomyFeatureType[]|null
     */
    public function getTaxonomyFeature()
    {
        return $this->TaxonomyFeature;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxonomyFeature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxonomyFeature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxonomyFeatureForArrayConstraintsFromSetTaxonomyFeature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineTaxonomyTypeTaxonomyFeatureItem) {
            // validation for constraint: itemType
            if (!$airlineTaxonomyTypeTaxonomyFeatureItem instanceof \StructType\TaxonomyFeatureType) {
                $invalidValues[] = is_object($airlineTaxonomyTypeTaxonomyFeatureItem) ? get_class($airlineTaxonomyTypeTaxonomyFeatureItem) : sprintf('%s(%s)', gettype($airlineTaxonomyTypeTaxonomyFeatureItem), var_export($airlineTaxonomyTypeTaxonomyFeatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxonomyFeature property can only contain items of type \StructType\TaxonomyFeatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxonomyFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxonomyFeatureType[] $taxonomyFeature
     * @return \StructType\AirlineTaxonomyType
     */
    public function setTaxonomyFeature(array $taxonomyFeature = array())
    {
        // validation for constraint: array
        if ('' !== ($taxonomyFeatureArrayErrorMessage = self::validateTaxonomyFeatureForArrayConstraintsFromSetTaxonomyFeature($taxonomyFeature))) {
            throw new \InvalidArgumentException($taxonomyFeatureArrayErrorMessage, __LINE__);
        }
        $this->TaxonomyFeature = $taxonomyFeature;
        return $this;
    }
    /**
     * Add item to TaxonomyFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxonomyFeatureType $item
     * @return \StructType\AirlineTaxonomyType
     */
    public function addToTaxonomyFeature(\StructType\TaxonomyFeatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxonomyFeatureType) {
            throw new \InvalidArgumentException(sprintf('The TaxonomyFeature property can only contain items of type \StructType\TaxonomyFeatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxonomyFeature[] = $item;
        return $this;
    }
}
