<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineProfileFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Criteria to filter airline profile response information.
 * @subpackage Structs
 */
class AirlineProfileFilterCriteriaType extends AbstractStructBase
{
    /**
     * The AirlineProfileCriteria
     * Meta information extracted from the WSDL
     * - documentation: Specialization of Airline Profile for use in request messages as a filter. Distribution profile of an airline which describes which types of shopping requests may be processed by a particular carrier.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FilterAirlineProfileType[]
     */
    public $AirlineProfileCriteria;
    /**
     * The AllProfilesInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, all available profiles from all profile owners are requested. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AllProfilesInd;
    /**
     * The MediaURL_Ind
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, only a URL to an airline profile location should be provided. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MediaURL_Ind;
    /**
     * Constructor method for AirlineProfileFilterCriteriaType
     * @uses AirlineProfileFilterCriteriaType::setAirlineProfileCriteria()
     * @uses AirlineProfileFilterCriteriaType::setAllProfilesInd()
     * @uses AirlineProfileFilterCriteriaType::setMediaURL_Ind()
     * @param \StructType\FilterAirlineProfileType[] $airlineProfileCriteria
     * @param bool $allProfilesInd
     * @param bool $mediaURL_Ind
     */
    public function __construct(array $airlineProfileCriteria = array(), $allProfilesInd = null, $mediaURL_Ind = null)
    {
        $this
            ->setAirlineProfileCriteria($airlineProfileCriteria)
            ->setAllProfilesInd($allProfilesInd)
            ->setMediaURL_Ind($mediaURL_Ind);
    }
    /**
     * Get AirlineProfileCriteria value
     * @return \StructType\FilterAirlineProfileType[]|null
     */
    public function getAirlineProfileCriteria()
    {
        return $this->AirlineProfileCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineProfileCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineProfileCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineProfileCriteriaForArrayConstraintsFromSetAirlineProfileCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileFilterCriteriaTypeAirlineProfileCriteriaItem) {
            // validation for constraint: itemType
            if (!$airlineProfileFilterCriteriaTypeAirlineProfileCriteriaItem instanceof \StructType\FilterAirlineProfileType) {
                $invalidValues[] = is_object($airlineProfileFilterCriteriaTypeAirlineProfileCriteriaItem) ? get_class($airlineProfileFilterCriteriaTypeAirlineProfileCriteriaItem) : sprintf('%s(%s)', gettype($airlineProfileFilterCriteriaTypeAirlineProfileCriteriaItem), var_export($airlineProfileFilterCriteriaTypeAirlineProfileCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineProfileCriteria property can only contain items of type \StructType\FilterAirlineProfileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineProfileCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterAirlineProfileType[] $airlineProfileCriteria
     * @return \StructType\AirlineProfileFilterCriteriaType
     */
    public function setAirlineProfileCriteria(array $airlineProfileCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineProfileCriteriaArrayErrorMessage = self::validateAirlineProfileCriteriaForArrayConstraintsFromSetAirlineProfileCriteria($airlineProfileCriteria))) {
            throw new \InvalidArgumentException($airlineProfileCriteriaArrayErrorMessage, __LINE__);
        }
        $this->AirlineProfileCriteria = $airlineProfileCriteria;
        return $this;
    }
    /**
     * Add item to AirlineProfileCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FilterAirlineProfileType $item
     * @return \StructType\AirlineProfileFilterCriteriaType
     */
    public function addToAirlineProfileCriteria(\StructType\FilterAirlineProfileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FilterAirlineProfileType) {
            throw new \InvalidArgumentException(sprintf('The AirlineProfileCriteria property can only contain items of type \StructType\FilterAirlineProfileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineProfileCriteria[] = $item;
        return $this;
    }
    /**
     * Get AllProfilesInd value
     * @return bool|null
     */
    public function getAllProfilesInd()
    {
        return $this->AllProfilesInd;
    }
    /**
     * Set AllProfilesInd value
     * @param bool $allProfilesInd
     * @return \StructType\AirlineProfileFilterCriteriaType
     */
    public function setAllProfilesInd($allProfilesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allProfilesInd) && !is_bool($allProfilesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allProfilesInd, true), gettype($allProfilesInd)), __LINE__);
        }
        $this->AllProfilesInd = $allProfilesInd;
        return $this;
    }
    /**
     * Get MediaURL_Ind value
     * @return bool|null
     */
    public function getMediaURL_Ind()
    {
        return $this->MediaURL_Ind;
    }
    /**
     * Set MediaURL_Ind value
     * @param bool $mediaURL_Ind
     * @return \StructType\AirlineProfileFilterCriteriaType
     */
    public function setMediaURL_Ind($mediaURL_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($mediaURL_Ind) && !is_bool($mediaURL_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mediaURL_Ind, true), gettype($mediaURL_Ind)), __LINE__);
        }
        $this->MediaURL_Ind = $mediaURL_Ind;
        return $this;
    }
}
