<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffinityShoppingCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Affinity search includes a wide range of criteria including generic origin/destination information, trip time periods, as well as travel budget.
 * @subpackage Structs
 */
class AffinityShoppingCriteriaType extends AbstractStructBase
{
    /**
     * The AffinityOriginDest
     * Meta information extracted from the WSDL
     * - documentation: Origin and Destination information for affinity shopping requests.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AffinityOriginDestType[]
     */
    public $AffinityOriginDest;
    /**
     * The KeywordPref
     * Meta information extracted from the WSDL
     * - documentation: Contextual information to further describe something using a key-value pair.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePropertyType[]
     */
    public $KeywordPref;
    /**
     * The MaximumAmount
     * Meta information extracted from the WSDL
     * - documentation: Maximum amount for all Passengers (Payers) for a journey request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MaximumAmount;
    /**
     * The MinimumAmount
     * Meta information extracted from the WSDL
     * - documentation: Minimum amount for all Passengers (Payers) for a journey request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MinimumAmount;
    /**
     * The StayPeriod
     * Meta information extracted from the WSDL
     * - documentation: Time constraints for an Affinity Shopping request including specific Dates, Seasons, Months, or Durations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StayPeriodType
     */
    public $StayPeriod;
    /**
     * Constructor method for AffinityShoppingCriteriaType
     * @uses AffinityShoppingCriteriaType::setAffinityOriginDest()
     * @uses AffinityShoppingCriteriaType::setKeywordPref()
     * @uses AffinityShoppingCriteriaType::setMaximumAmount()
     * @uses AffinityShoppingCriteriaType::setMinimumAmount()
     * @uses AffinityShoppingCriteriaType::setStayPeriod()
     * @param \StructType\AffinityOriginDestType[] $affinityOriginDest
     * @param \StructType\KeyValuePropertyType[] $keywordPref
     * @param \StructType\AmountType $maximumAmount
     * @param \StructType\AmountType $minimumAmount
     * @param \StructType\StayPeriodType $stayPeriod
     */
    public function __construct(array $affinityOriginDest = array(), array $keywordPref = array(), \StructType\AmountType $maximumAmount = null, \StructType\AmountType $minimumAmount = null, \StructType\StayPeriodType $stayPeriod = null)
    {
        $this
            ->setAffinityOriginDest($affinityOriginDest)
            ->setKeywordPref($keywordPref)
            ->setMaximumAmount($maximumAmount)
            ->setMinimumAmount($minimumAmount)
            ->setStayPeriod($stayPeriod);
    }
    /**
     * Get AffinityOriginDest value
     * @return \StructType\AffinityOriginDestType[]
     */
    public function getAffinityOriginDest()
    {
        return $this->AffinityOriginDest;
    }
    /**
     * This method is responsible for validating the values passed to the setAffinityOriginDest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffinityOriginDest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffinityOriginDestForArrayConstraintsFromSetAffinityOriginDest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affinityShoppingCriteriaTypeAffinityOriginDestItem) {
            // validation for constraint: itemType
            if (!$affinityShoppingCriteriaTypeAffinityOriginDestItem instanceof \StructType\AffinityOriginDestType) {
                $invalidValues[] = is_object($affinityShoppingCriteriaTypeAffinityOriginDestItem) ? get_class($affinityShoppingCriteriaTypeAffinityOriginDestItem) : sprintf('%s(%s)', gettype($affinityShoppingCriteriaTypeAffinityOriginDestItem), var_export($affinityShoppingCriteriaTypeAffinityOriginDestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AffinityOriginDest property can only contain items of type \StructType\AffinityOriginDestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffinityOriginDest value
     * @throws \InvalidArgumentException
     * @param \StructType\AffinityOriginDestType[] $affinityOriginDest
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function setAffinityOriginDest(array $affinityOriginDest = array())
    {
        // validation for constraint: array
        if ('' !== ($affinityOriginDestArrayErrorMessage = self::validateAffinityOriginDestForArrayConstraintsFromSetAffinityOriginDest($affinityOriginDest))) {
            throw new \InvalidArgumentException($affinityOriginDestArrayErrorMessage, __LINE__);
        }
        $this->AffinityOriginDest = $affinityOriginDest;
        return $this;
    }
    /**
     * Add item to AffinityOriginDest value
     * @throws \InvalidArgumentException
     * @param \StructType\AffinityOriginDestType $item
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function addToAffinityOriginDest(\StructType\AffinityOriginDestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffinityOriginDestType) {
            throw new \InvalidArgumentException(sprintf('The AffinityOriginDest property can only contain items of type \StructType\AffinityOriginDestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AffinityOriginDest[] = $item;
        return $this;
    }
    /**
     * Get KeywordPref value
     * @return \StructType\KeyValuePropertyType[]|null
     */
    public function getKeywordPref()
    {
        return $this->KeywordPref;
    }
    /**
     * This method is responsible for validating the values passed to the setKeywordPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeywordPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeywordPrefForArrayConstraintsFromSetKeywordPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affinityShoppingCriteriaTypeKeywordPrefItem) {
            // validation for constraint: itemType
            if (!$affinityShoppingCriteriaTypeKeywordPrefItem instanceof \StructType\KeyValuePropertyType) {
                $invalidValues[] = is_object($affinityShoppingCriteriaTypeKeywordPrefItem) ? get_class($affinityShoppingCriteriaTypeKeywordPrefItem) : sprintf('%s(%s)', gettype($affinityShoppingCriteriaTypeKeywordPrefItem), var_export($affinityShoppingCriteriaTypeKeywordPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeywordPref property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeywordPref value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType[] $keywordPref
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function setKeywordPref(array $keywordPref = array())
    {
        // validation for constraint: array
        if ('' !== ($keywordPrefArrayErrorMessage = self::validateKeywordPrefForArrayConstraintsFromSetKeywordPref($keywordPref))) {
            throw new \InvalidArgumentException($keywordPrefArrayErrorMessage, __LINE__);
        }
        $this->KeywordPref = $keywordPref;
        return $this;
    }
    /**
     * Add item to KeywordPref value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType $item
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function addToKeywordPref(\StructType\KeyValuePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePropertyType) {
            throw new \InvalidArgumentException(sprintf('The KeywordPref property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KeywordPref[] = $item;
        return $this;
    }
    /**
     * Get MaximumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMaximumAmount()
    {
        return $this->MaximumAmount;
    }
    /**
     * Set MaximumAmount value
     * @param \StructType\AmountType $maximumAmount
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function setMaximumAmount(\StructType\AmountType $maximumAmount = null)
    {
        $this->MaximumAmount = $maximumAmount;
        return $this;
    }
    /**
     * Get MinimumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMinimumAmount()
    {
        return $this->MinimumAmount;
    }
    /**
     * Set MinimumAmount value
     * @param \StructType\AmountType $minimumAmount
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function setMinimumAmount(\StructType\AmountType $minimumAmount = null)
    {
        $this->MinimumAmount = $minimumAmount;
        return $this;
    }
    /**
     * Get StayPeriod value
     * @return \StructType\StayPeriodType|null
     */
    public function getStayPeriod()
    {
        return $this->StayPeriod;
    }
    /**
     * Set StayPeriod value
     * @param \StructType\StayPeriodType $stayPeriod
     * @return \StructType\AffinityShoppingCriteriaType
     */
    public function setStayPeriod(\StructType\StayPeriodType $stayPeriod = null)
    {
        $this->StayPeriod = $stayPeriod;
        return $this;
    }
}
