<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffinityOriginDestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Origin and Destination information for affinity shopping requests.
 * @subpackage Structs
 */
class AffinityOriginDestType extends AbstractStructBase
{
    /**
     * The AffinityArrivalRequest
     * Meta information extracted from the WSDL
     * - documentation: Arrival information for affinity shopping requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AffinityArrivalRequestType
     */
    public $AffinityArrivalRequest;
    /**
     * The AffinityDepRequest
     * Meta information extracted from the WSDL
     * - documentation: Departure information for affinity shopping requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AffinityDepRequestType
     */
    public $AffinityDepRequest;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Shopping Request specialisation of Cabin Type base type definition: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestCabinTypeType[]
     */
    public $CabinType;
    /**
     * The ConnectionCriteriaRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a unique identifier assigned to this transfer preference. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionCriteriaRefID;
    /**
     * The JourneyDurationCriteria
     * Meta information extracted from the WSDL
     * - documentation: Total journey travel time per bound preferences. This includes the sum of all flight durations as well as connection times.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JourneyDurationCriteriaType
     */
    public $JourneyDurationCriteria;
    /**
     * Constructor method for AffinityOriginDestType
     * @uses AffinityOriginDestType::setAffinityArrivalRequest()
     * @uses AffinityOriginDestType::setAffinityDepRequest()
     * @uses AffinityOriginDestType::setCabinType()
     * @uses AffinityOriginDestType::setConnectionCriteriaRefID()
     * @uses AffinityOriginDestType::setJourneyDurationCriteria()
     * @param \StructType\AffinityArrivalRequestType $affinityArrivalRequest
     * @param \StructType\AffinityDepRequestType $affinityDepRequest
     * @param \StructType\ShoppingRequestCabinTypeType[] $cabinType
     * @param string $connectionCriteriaRefID
     * @param \StructType\JourneyDurationCriteriaType $journeyDurationCriteria
     */
    public function __construct(\StructType\AffinityArrivalRequestType $affinityArrivalRequest = null, \StructType\AffinityDepRequestType $affinityDepRequest = null, array $cabinType = array(), $connectionCriteriaRefID = null, \StructType\JourneyDurationCriteriaType $journeyDurationCriteria = null)
    {
        $this
            ->setAffinityArrivalRequest($affinityArrivalRequest)
            ->setAffinityDepRequest($affinityDepRequest)
            ->setCabinType($cabinType)
            ->setConnectionCriteriaRefID($connectionCriteriaRefID)
            ->setJourneyDurationCriteria($journeyDurationCriteria);
    }
    /**
     * Get AffinityArrivalRequest value
     * @return \StructType\AffinityArrivalRequestType|null
     */
    public function getAffinityArrivalRequest()
    {
        return $this->AffinityArrivalRequest;
    }
    /**
     * Set AffinityArrivalRequest value
     * @param \StructType\AffinityArrivalRequestType $affinityArrivalRequest
     * @return \StructType\AffinityOriginDestType
     */
    public function setAffinityArrivalRequest(\StructType\AffinityArrivalRequestType $affinityArrivalRequest = null)
    {
        $this->AffinityArrivalRequest = $affinityArrivalRequest;
        return $this;
    }
    /**
     * Get AffinityDepRequest value
     * @return \StructType\AffinityDepRequestType|null
     */
    public function getAffinityDepRequest()
    {
        return $this->AffinityDepRequest;
    }
    /**
     * Set AffinityDepRequest value
     * @param \StructType\AffinityDepRequestType $affinityDepRequest
     * @return \StructType\AffinityOriginDestType
     */
    public function setAffinityDepRequest(\StructType\AffinityDepRequestType $affinityDepRequest = null)
    {
        $this->AffinityDepRequest = $affinityDepRequest;
        return $this;
    }
    /**
     * Get CabinType value
     * @return \StructType\ShoppingRequestCabinTypeType[]|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinTypeForArrayConstraintsFromSetCabinType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affinityOriginDestTypeCabinTypeItem) {
            // validation for constraint: itemType
            if (!$affinityOriginDestTypeCabinTypeItem instanceof \StructType\ShoppingRequestCabinTypeType) {
                $invalidValues[] = is_object($affinityOriginDestTypeCabinTypeItem) ? get_class($affinityOriginDestTypeCabinTypeItem) : sprintf('%s(%s)', gettype($affinityOriginDestTypeCabinTypeItem), var_export($affinityOriginDestTypeCabinTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinType property can only contain items of type \StructType\ShoppingRequestCabinTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestCabinTypeType[] $cabinType
     * @return \StructType\AffinityOriginDestType
     */
    public function setCabinType(array $cabinType = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinTypeArrayErrorMessage = self::validateCabinTypeForArrayConstraintsFromSetCabinType($cabinType))) {
            throw new \InvalidArgumentException($cabinTypeArrayErrorMessage, __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Add item to CabinType value
     * @throws \InvalidArgumentException
     * @param \StructType\ShoppingRequestCabinTypeType $item
     * @return \StructType\AffinityOriginDestType
     */
    public function addToCabinType(\StructType\ShoppingRequestCabinTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShoppingRequestCabinTypeType) {
            throw new \InvalidArgumentException(sprintf('The CabinType property can only contain items of type \StructType\ShoppingRequestCabinTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinType[] = $item;
        return $this;
    }
    /**
     * Get ConnectionCriteriaRefID value
     * @return string|null
     */
    public function getConnectionCriteriaRefID()
    {
        return $this->ConnectionCriteriaRefID;
    }
    /**
     * Set ConnectionCriteriaRefID value
     * @param string $connectionCriteriaRefID
     * @return \StructType\AffinityOriginDestType
     */
    public function setConnectionCriteriaRefID($connectionCriteriaRefID = null)
    {
        // validation for constraint: string
        if (!is_null($connectionCriteriaRefID) && !is_string($connectionCriteriaRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionCriteriaRefID, true), gettype($connectionCriteriaRefID)), __LINE__);
        }
        $this->ConnectionCriteriaRefID = $connectionCriteriaRefID;
        return $this;
    }
    /**
     * Get JourneyDurationCriteria value
     * @return \StructType\JourneyDurationCriteriaType|null
     */
    public function getJourneyDurationCriteria()
    {
        return $this->JourneyDurationCriteria;
    }
    /**
     * Set JourneyDurationCriteria value
     * @param \StructType\JourneyDurationCriteriaType $journeyDurationCriteria
     * @return \StructType\AffinityOriginDestType
     */
    public function setJourneyDurationCriteria(\StructType\JourneyDurationCriteriaType $journeyDurationCriteria = null)
    {
        $this->JourneyDurationCriteria = $journeyDurationCriteria;
        return $this;
    }
}
