<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffinityDepRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Departure information for affinity shopping requests.
 * @subpackage Structs
 */
class AffinityDepRequestType extends AbstractStructBase
{
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: A nation with its own government, occupying a particular territory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Country;
    /**
     * The CountrySubDivision
     * Meta information extracted from the WSDL
     * - documentation: An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountrySubDivisionType
     */
    public $CountrySubDivision;
    /**
     * The DateTimeFrom
     * Meta information extracted from the WSDL
     * - documentation: The customer's requested departure 'date time from' as part of a date time range. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeFrom;
    /**
     * The DateTimeTo
     * Meta information extracted from the WSDL
     * - documentation: The customer's requested departure 'date time to' as part of a date time range. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeTo;
    /**
     * The ProximityDistanceMeasure
     * Meta information extracted from the WSDL
     * - documentation: Departure information for affinity shopping requests. Possible Unit Code Values:'M' (Miles) or 'km' (Kilometers)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $ProximityDistanceMeasure;
    /**
     * The Station
     * Meta information extracted from the WSDL
     * - documentation: Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off. Those of relevance to the airline industry are identified by an IATA Location
     * Identifier (3 letter location identifier). There are also additional airports without an IATA identifier that may be used in disruption scenarios that will be identified by an ICAO 4 letter code (assigned to every registered airport, military or
     * civil). Business Identifier Fields: - IATA Location Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StationType
     */
    public $Station;
    /**
     * Constructor method for AffinityDepRequestType
     * @uses AffinityDepRequestType::setCountry()
     * @uses AffinityDepRequestType::setCountrySubDivision()
     * @uses AffinityDepRequestType::setDateTimeFrom()
     * @uses AffinityDepRequestType::setDateTimeTo()
     * @uses AffinityDepRequestType::setProximityDistanceMeasure()
     * @uses AffinityDepRequestType::setStation()
     * @param \StructType\CountryType $country
     * @param \StructType\CountrySubDivisionType $countrySubDivision
     * @param string $dateTimeFrom
     * @param string $dateTimeTo
     * @param \StructType\MeasureType $proximityDistanceMeasure
     * @param \StructType\StationType $station
     */
    public function __construct(\StructType\CountryType $country = null, \StructType\CountrySubDivisionType $countrySubDivision = null, $dateTimeFrom = null, $dateTimeTo = null, \StructType\MeasureType $proximityDistanceMeasure = null, \StructType\StationType $station = null)
    {
        $this
            ->setCountry($country)
            ->setCountrySubDivision($countrySubDivision)
            ->setDateTimeFrom($dateTimeFrom)
            ->setDateTimeTo($dateTimeTo)
            ->setProximityDistanceMeasure($proximityDistanceMeasure)
            ->setStation($station);
    }
    /**
     * Get Country value
     * @return \StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryType $country
     * @return \StructType\AffinityDepRequestType
     */
    public function setCountry(\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountrySubDivision value
     * @return \StructType\CountrySubDivisionType|null
     */
    public function getCountrySubDivision()
    {
        return $this->CountrySubDivision;
    }
    /**
     * Set CountrySubDivision value
     * @param \StructType\CountrySubDivisionType $countrySubDivision
     * @return \StructType\AffinityDepRequestType
     */
    public function setCountrySubDivision(\StructType\CountrySubDivisionType $countrySubDivision = null)
    {
        $this->CountrySubDivision = $countrySubDivision;
        return $this;
    }
    /**
     * Get DateTimeFrom value
     * @return string|null
     */
    public function getDateTimeFrom()
    {
        return $this->DateTimeFrom;
    }
    /**
     * Set DateTimeFrom value
     * @param string $dateTimeFrom
     * @return \StructType\AffinityDepRequestType
     */
    public function setDateTimeFrom($dateTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeFrom) && !is_string($dateTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeFrom, true), gettype($dateTimeFrom)), __LINE__);
        }
        $this->DateTimeFrom = $dateTimeFrom;
        return $this;
    }
    /**
     * Get DateTimeTo value
     * @return string|null
     */
    public function getDateTimeTo()
    {
        return $this->DateTimeTo;
    }
    /**
     * Set DateTimeTo value
     * @param string $dateTimeTo
     * @return \StructType\AffinityDepRequestType
     */
    public function setDateTimeTo($dateTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeTo) && !is_string($dateTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeTo, true), gettype($dateTimeTo)), __LINE__);
        }
        $this->DateTimeTo = $dateTimeTo;
        return $this;
    }
    /**
     * Get ProximityDistanceMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getProximityDistanceMeasure()
    {
        return $this->ProximityDistanceMeasure;
    }
    /**
     * Set ProximityDistanceMeasure value
     * @param \StructType\MeasureType $proximityDistanceMeasure
     * @return \StructType\AffinityDepRequestType
     */
    public function setProximityDistanceMeasure(\StructType\MeasureType $proximityDistanceMeasure = null)
    {
        $this->ProximityDistanceMeasure = $proximityDistanceMeasure;
        return $this;
    }
    /**
     * Get Station value
     * @return \StructType\StationType|null
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * Set Station value
     * @param \StructType\StationType $station
     * @return \StructType\AffinityDepRequestType
     */
    public function setStation(\StructType\StationType $station = null)
    {
        $this->Station = $station;
        return $this;
    }
}
