<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adjustment StructType
 * Meta information extracted from the WSDL
 * - documentation: Adjusted amount
 * @subpackage Structs
 */
class Adjustment extends AbstractStructBase
{
    /**
     * The _
     * @var int
     */
    public $_;
    /**
     * The Input
     * Meta information extracted from the WSDL
     * - documentation: Amount before adjustment
     * @var string
     */
    public $Input;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - documentation: Amount after adjustment
     * @var string
     */
    public $Result;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - documentation: Calculation percentage value. Example: 12.5
     * @var float
     */
    public $Percentage;
    /**
     * Constructor method for Adjustment
     * @uses Adjustment::set_()
     * @uses Adjustment::setInput()
     * @uses Adjustment::setResult()
     * @uses Adjustment::setPercentage()
     * @param int $_
     * @param string $input
     * @param string $result
     * @param float $percentage
     */
    public function __construct($_ = null, $input = null, $result = null, $percentage = null)
    {
        $this
            ->set_($_)
            ->setInput($input)
            ->setResult($result)
            ->setPercentage($percentage);
    }
    /**
     * Get _ value
     * @return int|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param int $_
     * @return \StructType\Adjustment
     */
    public function set_($_ = null)
    {
        // validation for constraint: int
        if (!is_null($_) && !(is_int($_) || ctype_digit($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Input value
     * @return string|null
     */
    public function getInput()
    {
        return $this->Input;
    }
    /**
     * Set Input value
     * @param string $input
     * @return \StructType\Adjustment
     */
    public function setInput($input = null)
    {
        // validation for constraint: string
        if (!is_null($input) && !is_string($input)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($input, true), gettype($input)), __LINE__);
        }
        $this->Input = $input;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\Adjustment
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\Adjustment
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
}
