<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddlNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: An additional name type. The structure consists of a generic proper name with associated type. Examples: Name - 'Smith'. Name Type Code - 'Fathers Surname'. Name - 'Park'. Name Type Code - 'Mothers Surname'.
 * @subpackage Structs
 */
class AddlNameType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: A proper name defined by the associated name type code and further clarified by the description text. Name - 'Smith'. Name Type Code - 'Father Surname'. Name - 'Park'. Name Type Code - 'Mother Surname'. | BDT with value constraints
     * for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The NameTypeCode
     * Meta information extracted from the WSDL
     * - documentation: This will define allowable additional name types. 'Father Surname' 'Mother Surname' | The type of proper name Examples: 'Father Surname'. 'Mother Surname'.
     * - base: AddlNameTypeCodeType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameTypeCode;
    /**
     * Constructor method for AddlNameType
     * @uses AddlNameType::setName()
     * @uses AddlNameType::setNameTypeCode()
     * @param string $name
     * @param string $nameTypeCode
     */
    public function __construct($name = null, $nameTypeCode = null)
    {
        $this
            ->setName($name)
            ->setNameTypeCode($nameTypeCode);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AddlNameType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameTypeCode value
     * @return string|null
     */
    public function getNameTypeCode()
    {
        return $this->NameTypeCode;
    }
    /**
     * Set NameTypeCode value
     * @param string $nameTypeCode
     * @return \StructType\AddlNameType
     */
    public function setNameTypeCode($nameTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($nameTypeCode) && !is_string($nameTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameTypeCode, true), gettype($nameTypeCode)), __LINE__);
        }
        $this->NameTypeCode = $nameTypeCode;
        return $this;
    }
}
