<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: An Order is the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold to
 * multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class AccountedServiceType extends AbstractStructBase
{
    /**
     * The InternalValue
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountedPriceType
     */
    public $InternalValue;
    /**
     * The OrderServiceAssociation
     * Meta information extracted from the WSDL
     * - documentation: Order Service Association
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderServiceAssociationType
     */
    public $OrderServiceAssociation;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The AccountingCode
     * Meta information extracted from the WSDL
     * - documentation: Grouping of services might be mapped to RFIC | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountingCode;
    /**
     * The AccountingSubCode
     * Meta information extracted from the WSDL
     * - documentation: Service identifier might be mapped to RFISC | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountingSubCode;
    /**
     * The ActionCode
     * Meta information extracted from the WSDL
     * - documentation: To indicate the creation, update and removal of a service | Indicates a creation, update or removal action.
     * - base: ActionCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActionCode;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The DeliveryStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Service Delivery Service Status instance. See ATSB Codeset DeliveryService for possible values. | Shows the possible statuses of a service delivery item. {codeListAgencyName}IATA Code List{/codeListAgencyName}
     * {codeListName}Delivery Service Status, Coded.{/codeListName} {codeListIdentifier}DELIVERYSERVICE{/codeListIdentifier} | Represents the current status of a service delivery item
     * - base: ServiceDeliveryStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStatusCode;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text for textual description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The InternalValueDifference
     * Meta information extracted from the WSDL
     * - documentation: Details of amounts that result in the difference between price of the OfferItem presented to the customer and the actual cost that airline will base (e.g. in cases of airline-initiated changes, such as disruption of schedule change)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPriceType
     */
    public $InternalValueDifference;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the Service was last modified. Examples: 2024-01-25T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The ResponsibleAirline
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ResponsibleAirline;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceRefID;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType
     */
    public $SettlementInfo;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Service Status instance. See ATSB Codeset OrderService for possible values. | The possible statuses of an Order Service {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Service
     * Status,coded{/codeListName} {codeListIdentifier}ORDERSERVICE{/codeListIdentifier} | represents the statuses of an Order Service
     * - base: OrderServiceStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The UnchangedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicated that this service is unchanged after reshopping. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UnchangedInd;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for AccountedServiceType
     * @uses AccountedServiceType::setInternalValue()
     * @uses AccountedServiceType::setOrderServiceAssociation()
     * @uses AccountedServiceType::setPaxRefID()
     * @uses AccountedServiceType::setServiceID()
     * @uses AccountedServiceType::setAccountingCode()
     * @uses AccountedServiceType::setAccountingSubCode()
     * @uses AccountedServiceType::setActionCode()
     * @uses AccountedServiceType::setBookingRef()
     * @uses AccountedServiceType::setDeliveryStatusCode()
     * @uses AccountedServiceType::setDescText()
     * @uses AccountedServiceType::setInternalValueDifference()
     * @uses AccountedServiceType::setLastModifiedDateTime()
     * @uses AccountedServiceType::setResponsibleAirline()
     * @uses AccountedServiceType::setServiceRefID()
     * @uses AccountedServiceType::setSettlementInfo()
     * @uses AccountedServiceType::setStatusCode()
     * @uses AccountedServiceType::setUnchangedInd()
     * @uses AccountedServiceType::setValidatingCarrier()
     * @param \StructType\AccountedPriceType $internalValue
     * @param \StructType\OrderServiceAssociationType $orderServiceAssociation
     * @param string $paxRefID
     * @param string $serviceID
     * @param string $accountingCode
     * @param string $accountingSubCode
     * @param string $actionCode
     * @param \StructType\BookingRefType[] $bookingRef
     * @param string $deliveryStatusCode
     * @param string $descText
     * @param \StructType\AccountedPriceType $internalValueDifference
     * @param string $lastModifiedDateTime
     * @param \StructType\CarrierType $responsibleAirline
     * @param string $serviceRefID
     * @param \StructType\SettlementInfoType $settlementInfo
     * @param string $statusCode
     * @param bool $unchangedInd
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct(\StructType\AccountedPriceType $internalValue = null, \StructType\OrderServiceAssociationType $orderServiceAssociation = null, $paxRefID = null, $serviceID = null, $accountingCode = null, $accountingSubCode = null, $actionCode = null, array $bookingRef = array(), $deliveryStatusCode = null, $descText = null, \StructType\AccountedPriceType $internalValueDifference = null, $lastModifiedDateTime = null, \StructType\CarrierType $responsibleAirline = null, $serviceRefID = null, \StructType\SettlementInfoType $settlementInfo = null, $statusCode = null, $unchangedInd = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setInternalValue($internalValue)
            ->setOrderServiceAssociation($orderServiceAssociation)
            ->setPaxRefID($paxRefID)
            ->setServiceID($serviceID)
            ->setAccountingCode($accountingCode)
            ->setAccountingSubCode($accountingSubCode)
            ->setActionCode($actionCode)
            ->setBookingRef($bookingRef)
            ->setDeliveryStatusCode($deliveryStatusCode)
            ->setDescText($descText)
            ->setInternalValueDifference($internalValueDifference)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setResponsibleAirline($responsibleAirline)
            ->setServiceRefID($serviceRefID)
            ->setSettlementInfo($settlementInfo)
            ->setStatusCode($statusCode)
            ->setUnchangedInd($unchangedInd)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get InternalValue value
     * @return \StructType\AccountedPriceType
     */
    public function getInternalValue()
    {
        return $this->InternalValue;
    }
    /**
     * Set InternalValue value
     * @param \StructType\AccountedPriceType $internalValue
     * @return \StructType\AccountedServiceType
     */
    public function setInternalValue(\StructType\AccountedPriceType $internalValue = null)
    {
        $this->InternalValue = $internalValue;
        return $this;
    }
    /**
     * Get OrderServiceAssociation value
     * @return \StructType\OrderServiceAssociationType
     */
    public function getOrderServiceAssociation()
    {
        return $this->OrderServiceAssociation;
    }
    /**
     * Set OrderServiceAssociation value
     * @param \StructType\OrderServiceAssociationType $orderServiceAssociation
     * @return \StructType\AccountedServiceType
     */
    public function setOrderServiceAssociation(\StructType\OrderServiceAssociationType $orderServiceAssociation = null)
    {
        $this->OrderServiceAssociation = $orderServiceAssociation;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\AccountedServiceType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\AccountedServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \StructType\AccountedServiceType
     */
    public function setAccountingCode($accountingCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountingCode) && !is_string($accountingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingCode, true), gettype($accountingCode)), __LINE__);
        }
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get AccountingSubCode value
     * @return string|null
     */
    public function getAccountingSubCode()
    {
        return $this->AccountingSubCode;
    }
    /**
     * Set AccountingSubCode value
     * @param string $accountingSubCode
     * @return \StructType\AccountedServiceType
     */
    public function setAccountingSubCode($accountingSubCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountingSubCode) && !is_string($accountingSubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingSubCode, true), gettype($accountingSubCode)), __LINE__);
        }
        $this->AccountingSubCode = $accountingSubCode;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \StructType\AccountedServiceType
     */
    public function setActionCode($actionCode = null)
    {
        // validation for constraint: string
        if (!is_null($actionCode) && !is_string($actionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionCode, true), gettype($actionCode)), __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedServiceTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$accountedServiceTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($accountedServiceTypeBookingRefItem) ? get_class($accountedServiceTypeBookingRefItem) : sprintf('%s(%s)', gettype($accountedServiceTypeBookingRefItem), var_export($accountedServiceTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\AccountedServiceType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingRef) && count($bookingRef) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\AccountedServiceType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingRef) && count($this->BookingRef) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingRef)), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get DeliveryStatusCode value
     * @return string|null
     */
    public function getDeliveryStatusCode()
    {
        return $this->DeliveryStatusCode;
    }
    /**
     * Set DeliveryStatusCode value
     * @param string $deliveryStatusCode
     * @return \StructType\AccountedServiceType
     */
    public function setDeliveryStatusCode($deliveryStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStatusCode) && !is_string($deliveryStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStatusCode, true), gettype($deliveryStatusCode)), __LINE__);
        }
        $this->DeliveryStatusCode = $deliveryStatusCode;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\AccountedServiceType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get InternalValueDifference value
     * @return \StructType\AccountedPriceType|null
     */
    public function getInternalValueDifference()
    {
        return $this->InternalValueDifference;
    }
    /**
     * Set InternalValueDifference value
     * @param \StructType\AccountedPriceType $internalValueDifference
     * @return \StructType\AccountedServiceType
     */
    public function setInternalValueDifference(\StructType\AccountedPriceType $internalValueDifference = null)
    {
        $this->InternalValueDifference = $internalValueDifference;
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return $this->LastModifiedDateTime;
    }
    /**
     * Set LastModifiedDateTime value
     * @param string $lastModifiedDateTime
     * @return \StructType\AccountedServiceType
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDateTime, true), gettype($lastModifiedDateTime)), __LINE__);
        }
        $this->LastModifiedDateTime = $lastModifiedDateTime;
        return $this;
    }
    /**
     * Get ResponsibleAirline value
     * @return \StructType\CarrierType|null
     */
    public function getResponsibleAirline()
    {
        return $this->ResponsibleAirline;
    }
    /**
     * Set ResponsibleAirline value
     * @param \StructType\CarrierType $responsibleAirline
     * @return \StructType\AccountedServiceType
     */
    public function setResponsibleAirline(\StructType\CarrierType $responsibleAirline = null)
    {
        $this->ResponsibleAirline = $responsibleAirline;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\AccountedServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * Set SettlementInfo value
     * @param \StructType\SettlementInfoType $settlementInfo
     * @return \StructType\AccountedServiceType
     */
    public function setSettlementInfo(\StructType\SettlementInfoType $settlementInfo = null)
    {
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\AccountedServiceType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get UnchangedInd value
     * @return bool|null
     */
    public function getUnchangedInd()
    {
        return $this->UnchangedInd;
    }
    /**
     * Set UnchangedInd value
     * @param bool $unchangedInd
     * @return \StructType\AccountedServiceType
     */
    public function setUnchangedInd($unchangedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($unchangedInd) && !is_bool($unchangedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unchangedInd, true), gettype($unchangedInd)), __LINE__);
        }
        $this->UnchangedInd = $unchangedInd;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\AccountedServiceType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
