<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedPriceDifferentialType StructType
 * Meta information extracted from the WSDL
 * - documentation: For each OfferItem, this function allows the airline to inform the seller about amount differential type if this OfferItem is chosen.
 * @subpackage Structs
 */
class AccountedPriceDifferentialType extends AbstractStructBase
{
    /**
     * The DifferentialTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Several types of action are possible when the customer selects a reshopped offer- | Price Differential Type Code
     * - base: DifferentialTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DifferentialTypeCode;
    /**
     * The DiffPrice
     * Meta information extracted from the WSDL
     * - documentation: A specialization of a container for Diff Price and Fare detail information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountedDiffPriceAndFareDetailsType
     */
    public $DiffPrice;
    /**
     * The NewPrice
     * Meta information extracted from the WSDL
     * - documentation: A container for Price and Fare detail information.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountingPriceAndFareDetailsType
     */
    public $NewPrice;
    /**
     * The OldPrice
     * Meta information extracted from the WSDL
     * - documentation: A container for Price and Fare detail information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountingPriceAndFareDetailsType
     */
    public $OldPrice;
    /**
     * Constructor method for AccountedPriceDifferentialType
     * @uses AccountedPriceDifferentialType::setDifferentialTypeCode()
     * @uses AccountedPriceDifferentialType::setDiffPrice()
     * @uses AccountedPriceDifferentialType::setNewPrice()
     * @uses AccountedPriceDifferentialType::setOldPrice()
     * @param string $differentialTypeCode
     * @param \StructType\AccountedDiffPriceAndFareDetailsType $diffPrice
     * @param \StructType\AccountingPriceAndFareDetailsType $newPrice
     * @param \StructType\AccountingPriceAndFareDetailsType $oldPrice
     */
    public function __construct($differentialTypeCode = null, \StructType\AccountedDiffPriceAndFareDetailsType $diffPrice = null, \StructType\AccountingPriceAndFareDetailsType $newPrice = null, \StructType\AccountingPriceAndFareDetailsType $oldPrice = null)
    {
        $this
            ->setDifferentialTypeCode($differentialTypeCode)
            ->setDiffPrice($diffPrice)
            ->setNewPrice($newPrice)
            ->setOldPrice($oldPrice);
    }
    /**
     * Get DifferentialTypeCode value
     * @return string
     */
    public function getDifferentialTypeCode()
    {
        return $this->DifferentialTypeCode;
    }
    /**
     * Set DifferentialTypeCode value
     * @param string $differentialTypeCode
     * @return \StructType\AccountedPriceDifferentialType
     */
    public function setDifferentialTypeCode($differentialTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($differentialTypeCode) && !is_string($differentialTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($differentialTypeCode, true), gettype($differentialTypeCode)), __LINE__);
        }
        $this->DifferentialTypeCode = $differentialTypeCode;
        return $this;
    }
    /**
     * Get DiffPrice value
     * @return \StructType\AccountedDiffPriceAndFareDetailsType
     */
    public function getDiffPrice()
    {
        return $this->DiffPrice;
    }
    /**
     * Set DiffPrice value
     * @param \StructType\AccountedDiffPriceAndFareDetailsType $diffPrice
     * @return \StructType\AccountedPriceDifferentialType
     */
    public function setDiffPrice(\StructType\AccountedDiffPriceAndFareDetailsType $diffPrice = null)
    {
        $this->DiffPrice = $diffPrice;
        return $this;
    }
    /**
     * Get NewPrice value
     * @return \StructType\AccountingPriceAndFareDetailsType
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param \StructType\AccountingPriceAndFareDetailsType $newPrice
     * @return \StructType\AccountedPriceDifferentialType
     */
    public function setNewPrice(\StructType\AccountingPriceAndFareDetailsType $newPrice = null)
    {
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get OldPrice value
     * @return \StructType\AccountingPriceAndFareDetailsType|null
     */
    public function getOldPrice()
    {
        return $this->OldPrice;
    }
    /**
     * Set OldPrice value
     * @param \StructType\AccountingPriceAndFareDetailsType $oldPrice
     * @return \StructType\AccountedPriceDifferentialType
     */
    public function setOldPrice(\StructType\AccountingPriceAndFareDetailsType $oldPrice = null)
    {
        $this->OldPrice = $oldPrice;
        return $this;
    }
}
