<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedPenaltyInfoListType StructType
 * Meta information extracted from the WSDL
 * - documentation: list of Order Penalty Information.
 * @subpackage Structs
 */
class AccountedPenaltyInfoListType extends AbstractStructBase
{
    /**
     * The PenaltyInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to a penalty applied to an OrderItem following a servicing operation.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AccountedPenaltyInfoType[]
     */
    public $PenaltyInfo;
    /**
     * Constructor method for AccountedPenaltyInfoListType
     * @uses AccountedPenaltyInfoListType::setPenaltyInfo()
     * @param \StructType\AccountedPenaltyInfoType[] $penaltyInfo
     */
    public function __construct(array $penaltyInfo = array())
    {
        $this
            ->setPenaltyInfo($penaltyInfo);
    }
    /**
     * Get PenaltyInfo value
     * @return \StructType\AccountedPenaltyInfoType[]
     */
    public function getPenaltyInfo()
    {
        return $this->PenaltyInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyInfoForArrayConstraintsFromSetPenaltyInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPenaltyInfoListTypePenaltyInfoItem) {
            // validation for constraint: itemType
            if (!$accountedPenaltyInfoListTypePenaltyInfoItem instanceof \StructType\AccountedPenaltyInfoType) {
                $invalidValues[] = is_object($accountedPenaltyInfoListTypePenaltyInfoItem) ? get_class($accountedPenaltyInfoListTypePenaltyInfoItem) : sprintf('%s(%s)', gettype($accountedPenaltyInfoListTypePenaltyInfoItem), var_export($accountedPenaltyInfoListTypePenaltyInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyInfo property can only contain items of type \StructType\AccountedPenaltyInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedPenaltyInfoType[] $penaltyInfo
     * @return \StructType\AccountedPenaltyInfoListType
     */
    public function setPenaltyInfo(array $penaltyInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyInfoArrayErrorMessage = self::validatePenaltyInfoForArrayConstraintsFromSetPenaltyInfo($penaltyInfo))) {
            throw new \InvalidArgumentException($penaltyInfoArrayErrorMessage, __LINE__);
        }
        $this->PenaltyInfo = $penaltyInfo;
        return $this;
    }
    /**
     * Add item to PenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedPenaltyInfoType $item
     * @return \StructType\AccountedPenaltyInfoListType
     */
    public function addToPenaltyInfo(\StructType\AccountedPenaltyInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountedPenaltyInfoType) {
            throw new \InvalidArgumentException(sprintf('The PenaltyInfo property can only contain items of type \StructType\AccountedPenaltyInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyInfo[] = $item;
        return $this;
    }
}
