<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedForfeitedInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to an amount which could not be recovered as a consequence of a servicing operation.
 * @subpackage Structs
 */
class AccountedForfeitedInfoType extends AbstractStructBase
{
    /**
     * The ForfeitedInfoID
     * Meta information extracted from the WSDL
     * - documentation: Forfeited assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForfeitedInfoID;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Service to where forfeited amount is recognized as revenue. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceRefID;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Forfeited creation timestamp. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID to which the penalty has been applied. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * Constructor method for AccountedForfeitedInfoType
     * @uses AccountedForfeitedInfoType::setForfeitedInfoID()
     * @uses AccountedForfeitedInfoType::setOrderItemRefID()
     * @uses AccountedForfeitedInfoType::setPrice()
     * @uses AccountedForfeitedInfoType::setServiceRefID()
     * @uses AccountedForfeitedInfoType::setCreationDateTime()
     * @uses AccountedForfeitedInfoType::setPaxRefID()
     * @param string $forfeitedInfoID
     * @param string $orderItemRefID
     * @param \StructType\PriceType $price
     * @param string $serviceRefID
     * @param string $creationDateTime
     * @param string $paxRefID
     */
    public function __construct($forfeitedInfoID = null, $orderItemRefID = null, \StructType\PriceType $price = null, $serviceRefID = null, $creationDateTime = null, $paxRefID = null)
    {
        $this
            ->setForfeitedInfoID($forfeitedInfoID)
            ->setOrderItemRefID($orderItemRefID)
            ->setPrice($price)
            ->setServiceRefID($serviceRefID)
            ->setCreationDateTime($creationDateTime)
            ->setPaxRefID($paxRefID);
    }
    /**
     * Get ForfeitedInfoID value
     * @return string
     */
    public function getForfeitedInfoID()
    {
        return $this->ForfeitedInfoID;
    }
    /**
     * Set ForfeitedInfoID value
     * @param string $forfeitedInfoID
     * @return \StructType\AccountedForfeitedInfoType
     */
    public function setForfeitedInfoID($forfeitedInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($forfeitedInfoID) && !is_string($forfeitedInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forfeitedInfoID, true), gettype($forfeitedInfoID)), __LINE__);
        }
        $this->ForfeitedInfoID = $forfeitedInfoID;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\AccountedForfeitedInfoType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\AccountedForfeitedInfoType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\AccountedForfeitedInfoType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\AccountedForfeitedInfoType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\AccountedForfeitedInfoType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
}
