<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptRepricedOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: A function used by seller to inform the airline that it is accepting the proposed Order, as it has been re-priced and returned in the preceding OrderReshopRS.
 * @subpackage Structs
 */
class AcceptRepricedOrderType extends AbstractStructBase
{
    /**
     * The OfferRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Offer ID for which this Payment applies. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $OfferRefID;
    /**
     * Constructor method for AcceptRepricedOrderType
     * @uses AcceptRepricedOrderType::setOfferRefID()
     * @param string[] $offerRefID
     */
    public function __construct(array $offerRefID = array())
    {
        $this
            ->setOfferRefID($offerRefID);
    }
    /**
     * Get OfferRefID value
     * @return string[]
     */
    public function getOfferRefID()
    {
        return $this->OfferRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferRefIDForArrayConstraintsFromSetOfferRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acceptRepricedOrderTypeOfferRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($acceptRepricedOrderTypeOfferRefIDItem)) {
                $invalidValues[] = is_object($acceptRepricedOrderTypeOfferRefIDItem) ? get_class($acceptRepricedOrderTypeOfferRefIDItem) : sprintf('%s(%s)', gettype($acceptRepricedOrderTypeOfferRefIDItem), var_export($acceptRepricedOrderTypeOfferRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferRefID value
     * @throws \InvalidArgumentException
     * @param string[] $offerRefID
     * @return \StructType\AcceptRepricedOrderType
     */
    public function setOfferRefID(array $offerRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($offerRefIDArrayErrorMessage = self::validateOfferRefIDForArrayConstraintsFromSetOfferRefID($offerRefID))) {
            throw new \InvalidArgumentException($offerRefIDArrayErrorMessage, __LINE__);
        }
        $this->OfferRefID = $offerRefID;
        return $this;
    }
    /**
     * Add item to OfferRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AcceptRepricedOrderType
     */
    public function addToOfferRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OfferRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferRefID[] = $item;
        return $this;
    }
}
