<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ATPCO StructType
 * Meta information extracted from the WSDL
 * - documentation: Attributes and S5/ S7 Diagnostics.
 * @subpackage Structs
 */
class ATPCO extends AbstractStructBase
{
    /**
     * The Group
     * @var \StructType\Group
     */
    public $Group;
    /**
     * The SubGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubGroup
     */
    public $SubGroup;
    /**
     * Constructor method for ATPCO
     * @uses ATPCO::setGroup()
     * @uses ATPCO::setSubGroup()
     * @param \StructType\Group $group
     * @param \StructType\SubGroup $subGroup
     */
    public function __construct(\StructType\Group $group = null, \StructType\SubGroup $subGroup = null)
    {
        $this
            ->setGroup($group)
            ->setSubGroup($subGroup);
    }
    /**
     * Get Group value
     * @return \StructType\Group|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param \StructType\Group $group
     * @return \StructType\ATPCO
     */
    public function setGroup(\StructType\Group $group = null)
    {
        $this->Group = $group;
        return $this;
    }
    /**
     * Get SubGroup value
     * @return \StructType\SubGroup|null
     */
    public function getSubGroup()
    {
        return $this->SubGroup;
    }
    /**
     * Set SubGroup value
     * @param \StructType\SubGroup $subGroup
     * @return \StructType\ATPCO
     */
    public function setSubGroup(\StructType\SubGroup $subGroup = null)
    {
        $this->SubGroup = $subGroup;
        return $this;
    }
}
