<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TaxExemptionQualificationCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration values for Tax exemption Qualification e.g SEZ (Special Economic Zone), UN , PSU (Public Sector Undertakings) {codeListAgencyName}IATA AIDM{/codeListAgencyName}
 * @subpackage Enumerations
 */
class TaxExemptionQualificationCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PSU'
     * Meta information extracted from the WSDL
     * - documentation: The commitments to pay was accepted./At the Payment Level to indicate that a payment has been authorized, etc. or the status in not needed
     * @return string 'PSU'
     */
    const VALUE_PSU = 'PSU';
    /**
     * Constant for value 'SEZ'
     * Meta information extracted from the WSDL
     * - documentation: The payment process was done.
     * @return string 'SEZ'
     */
    const VALUE_SEZ = 'SEZ';
    /**
     * Constant for value 'UN'
     * Meta information extracted from the WSDL
     * - documentation: The value of compensation was allocated to the corresponding Order Item.
     * @return string 'UN'
     */
    const VALUE_UN = 'UN';
    /**
     * Return allowed values
     * @uses self::VALUE_PSU
     * @uses self::VALUE_SEZ
     * @uses self::VALUE_UN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PSU,
            self::VALUE_SEZ,
            self::VALUE_UN,
        );
    }
}
