<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ServiceQualifier EnumType
 * Meta information extracted from the WSDL
 * - documentation: Qualify what is returned in IATA_ServiceListRS.Possible values are:"Ancillary" – return only filed optional services"OBFEE" - return only OB Fees"SSR" – return only SSRs"All" – return both filed optional services and SSRs
 * @subpackage Enumerations
 */
class ServiceQualifier extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Ancillary'
     * @return string 'Ancillary'
     */
    const VALUE_ANCILLARY = 'Ancillary';
    /**
     * Constant for value 'OBFEE'
     * @return string 'OBFEE'
     */
    const VALUE_OBFEE = 'OBFEE';
    /**
     * Constant for value 'SSR'
     * @return string 'SSR'
     */
    const VALUE_SSR = 'SSR';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return allowed values
     * @uses self::VALUE_ANCILLARY
     * @uses self::VALUE_OBFEE
     * @uses self::VALUE_SSR
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANCILLARY,
            self::VALUE_OBFEE,
            self::VALUE_SSR,
            self::VALUE_ALL,
        );
    }
}
