<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FarePriceTypeCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: Indicates if the fare price provided is a filed amount, net amount, or a sell amount.
 * @subpackage Enumerations
 */
class FarePriceTypeCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Filed'
     * Meta information extracted from the WSDL
     * - documentation: Filed
     * @return string 'Filed'
     */
    const VALUE_FILED = 'Filed';
    /**
     * Constant for value 'Net'
     * Meta information extracted from the WSDL
     * - documentation: Net
     * @return string 'Net'
     */
    const VALUE_NET = 'Net';
    /**
     * Return allowed values
     * @uses self::VALUE_FILED
     * @uses self::VALUE_NET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FILED,
            self::VALUE_NET,
        );
    }
}
