<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EventType EnumType
 * Meta information extracted from the WSDL
 * - documentation: ENR = EnrollmentANN = AnniversaryREV = Revenue TresholdADM = Administartion
 * @subpackage Enumerations
 */
class EventType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ENR'
     * @return string 'ENR'
     */
    const VALUE_ENR = 'ENR';
    /**
     * Constant for value 'ANN'
     * @return string 'ANN'
     */
    const VALUE_ANN = 'ANN';
    /**
     * Constant for value 'REV'
     * @return string 'REV'
     */
    const VALUE_REV = 'REV';
    /**
     * Constant for value 'ADM'
     * @return string 'ADM'
     */
    const VALUE_ADM = 'ADM';
    /**
     * Return allowed values
     * @uses self::VALUE_ENR
     * @uses self::VALUE_ANN
     * @uses self::VALUE_REV
     * @uses self::VALUE_ADM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENR,
            self::VALUE_ANN,
            self::VALUE_REV,
            self::VALUE_ADM,
        );
    }
}
