<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DeckCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration set for the Deck Code BDT.
 * @subpackage Enumerations
 */
class DeckCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Lower'
     * Meta information extracted from the WSDL
     * - documentation: Lower Deck
     * @return string 'Lower'
     */
    const VALUE_LOWER = 'Lower';
    /**
     * Constant for value 'Main'
     * Meta information extracted from the WSDL
     * - documentation: Main Deck
     * @return string 'Main'
     */
    const VALUE_MAIN = 'Main';
    /**
     * Constant for value 'Upper'
     * Meta information extracted from the WSDL
     * - documentation: Upper Deck
     * @return string 'Upper'
     */
    const VALUE_UPPER = 'Upper';
    /**
     * Return allowed values
     * @uses self::VALUE_LOWER
     * @uses self::VALUE_MAIN
     * @uses self::VALUE_UPPER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOWER,
            self::VALUE_MAIN,
            self::VALUE_UPPER,
        );
    }
}
