<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ChangeTypeCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: This identifies using Change type Code ENUM the type of change that applies to the condition. valid examples are NAME FLIGHT SERVICE
 * @subpackage Enumerations
 */
class ChangeTypeCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Flight'
     * Meta information extracted from the WSDL
     * - documentation: This identifies Flight detail changes. changes to the core flight details. departure and arrival points and airline. | This identifies Flight detail changes. changes to the core flight details. departure and arrival points and
     * airline.
     * @return string 'Flight'
     */
    const VALUE_FLIGHT = 'Flight';
    /**
     * Constant for value 'Name'
     * Meta information extracted from the WSDL
     * - documentation: Name based changes. Changes to the passenger(s) names. | Name based changes. Changes to the passenger(s) names.
     * @return string 'Name'
     */
    const VALUE_NAME = 'Name';
    /**
     * Constant for value 'Service'
     * Meta information extracted from the WSDL
     * - documentation: This identifies Service non flight changes. seat preferences/food/baggage etc. | This identifies Service non flight changes. seat preferences/food/baggage etc.
     * @return string 'Service'
     */
    const VALUE_SERVICE = 'Service';
    /**
     * Return allowed values
     * @uses self::VALUE_FLIGHT
     * @uses self::VALUE_NAME
     * @uses self::VALUE_SERVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FLIGHT,
            self::VALUE_NAME,
            self::VALUE_SERVICE,
        );
    }
}
