<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AddlNameTypeCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: This will include a codelist with defined types of additional names. {codeListAgencyName}IATA AIDM{/codeListAgencyName}
 * @subpackage Enumerations
 */
class AddlNameTypeCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Father Surname'
     * Meta information extracted from the WSDL
     * - documentation: This is the individuals fathers name surname which is part of the individuals full surname.
     * @return string 'Father Surname'
     */
    const VALUE_FATHER_SURNAME = 'Father Surname';
    /**
     * Constant for value 'Mother Surname'
     * Meta information extracted from the WSDL
     * - documentation: This is the individuals mothers name surname which is part of the individuals full surname.
     * @return string 'Mother Surname'
     */
    const VALUE_MOTHER_SURNAME = 'Mother Surname';
    /**
     * Constant for value 'EquivGivenName'
     * @return string 'EquivGivenName'
     */
    const VALUE_EQUIV_GIVEN_NAME = 'EquivGivenName';
    /**
     * Constant for value 'EquivSurname'
     * @return string 'EquivSurname'
     */
    const VALUE_EQUIV_SURNAME = 'EquivSurname';
    /**
     * Return allowed values
     * @uses self::VALUE_FATHER_SURNAME
     * @uses self::VALUE_MOTHER_SURNAME
     * @uses self::VALUE_EQUIV_GIVEN_NAME
     * @uses self::VALUE_EQUIV_SURNAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FATHER_SURNAME,
            self::VALUE_MOTHER_SURNAME,
            self::VALUE_EQUIV_GIVEN_NAME,
            self::VALUE_EQUIV_SURNAME,
        );
    }
}
