<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDictionaryRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Запрос на получение данных справочника
 * @subpackage Structs
 */
class GetDictionaryRequest extends AbstractStructBase
{
    /**
     * The dictId
     * Meta information extracted from the WSDL
     * - documentation: ID справочника (dictionary_type)
     * - minOccurs: 0
     * @var string
     */
    public $dictId;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Версия справочника
     * @var string
     */
    public $version;
    /**
     * The exportType
     * Meta information extracted from the WSDL
     * - documentation: Тип выгрузки ( CSV, XLSX, JSON, XML )
     * - minOccurs: 0
     * @var string
     */
    public $exportType;
    /**
     * The dictFromDt
     * Meta information extracted from the WSDL
     * - documentation: Начальная дата актуальности справочника
     * - minOccurs: 0
     * @var string
     */
    public $dictFromDt;
    /**
     * The dictToDt
     * Meta information extracted from the WSDL
     * - documentation: Конечная дата актуальности справочника
     * - minOccurs: 0
     * @var string
     */
    public $dictToDt;
    /**
     * Constructor method for GetDictionaryRequest
     * @uses GetDictionaryRequest::setDictId()
     * @uses GetDictionaryRequest::setVersion()
     * @uses GetDictionaryRequest::setExportType()
     * @uses GetDictionaryRequest::setDictFromDt()
     * @uses GetDictionaryRequest::setDictToDt()
     * @param string $dictId
     * @param string $version
     * @param string $exportType
     * @param string $dictFromDt
     * @param string $dictToDt
     */
    public function __construct($dictId = null, $version = null, $exportType = null, $dictFromDt = null, $dictToDt = null)
    {
        $this
            ->setDictId($dictId)
            ->setVersion($version)
            ->setExportType($exportType)
            ->setDictFromDt($dictFromDt)
            ->setDictToDt($dictToDt);
    }
    /**
     * Get dictId value
     * @return string|null
     */
    public function getDictId()
    {
        return $this->dictId;
    }
    /**
     * Set dictId value
     * @param string $dictId
     * @return \StructType\GetDictionaryRequest
     */
    public function setDictId($dictId = null)
    {
        // validation for constraint: string
        if (!is_null($dictId) && !is_string($dictId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictId, true), gettype($dictId)), __LINE__);
        }
        $this->dictId = $dictId;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\GetDictionaryRequest
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get exportType value
     * @return string|null
     */
    public function getExportType()
    {
        return $this->exportType;
    }
    /**
     * Set exportType value
     * @param string $exportType
     * @return \StructType\GetDictionaryRequest
     */
    public function setExportType($exportType = null)
    {
        // validation for constraint: string
        if (!is_null($exportType) && !is_string($exportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportType, true), gettype($exportType)), __LINE__);
        }
        $this->exportType = $exportType;
        return $this;
    }
    /**
     * Get dictFromDt value
     * @return string|null
     */
    public function getDictFromDt()
    {
        return $this->dictFromDt;
    }
    /**
     * Set dictFromDt value
     * @param string $dictFromDt
     * @return \StructType\GetDictionaryRequest
     */
    public function setDictFromDt($dictFromDt = null)
    {
        // validation for constraint: string
        if (!is_null($dictFromDt) && !is_string($dictFromDt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictFromDt, true), gettype($dictFromDt)), __LINE__);
        }
        $this->dictFromDt = $dictFromDt;
        return $this;
    }
    /**
     * Get dictToDt value
     * @return string|null
     */
    public function getDictToDt()
    {
        return $this->dictToDt;
    }
    /**
     * Set dictToDt value
     * @param string $dictToDt
     * @return \StructType\GetDictionaryRequest
     */
    public function setDictToDt($dictToDt = null)
    {
        // validation for constraint: string
        if (!is_null($dictToDt) && !is_string($dictToDt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictToDt, true), gettype($dictToDt)), __LINE__);
        }
        $this->dictToDt = $dictToDt;
        return $this;
    }
}
