<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonDictionaryResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Базовый объект ответа
 * @subpackage Structs
 */
class CommonDictionaryResponse extends AbstractStructBase
{
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - documentation: Уникальный id запроса
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $requestId;
    /**
     * The generatedAt
     * Meta information extracted from the WSDL
     * - documentation: Дата и время генерации ответа
     * - minOccurs: 1
     * @var string
     */
    public $generatedAt;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - documentation: Код ошибки
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - documentation: Сообщение об ошибке
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for CommonDictionaryResponse
     * @uses CommonDictionaryResponse::setRequestId()
     * @uses CommonDictionaryResponse::setGeneratedAt()
     * @uses CommonDictionaryResponse::setErrorCode()
     * @uses CommonDictionaryResponse::setErrorMessage()
     * @param string $requestId
     * @param string $generatedAt
     * @param string $errorCode
     * @param string $errorMessage
     */
    public function __construct($requestId = null, $generatedAt = null, $errorCode = null, $errorMessage = null)
    {
        $this
            ->setRequestId($requestId)
            ->setGeneratedAt($generatedAt)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get requestId value
     * @return string
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\CommonDictionaryResponse
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get generatedAt value
     * @return string
     */
    public function getGeneratedAt()
    {
        return $this->generatedAt;
    }
    /**
     * Set generatedAt value
     * @param string $generatedAt
     * @return \StructType\CommonDictionaryResponse
     */
    public function setGeneratedAt($generatedAt = null)
    {
        // validation for constraint: string
        if (!is_null($generatedAt) && !is_string($generatedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedAt, true), gettype($generatedAt)), __LINE__);
        }
        $this->generatedAt = $generatedAt;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\CommonDictionaryResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\CommonDictionaryResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
}
