<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckActionStateResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Общий ответ вебсервиса с данными
 * @subpackage Structs
 */
class CheckActionStateResponse extends CommonDictionaryResponse
{
    /**
     * The actionType
     * Meta information extracted from the WSDL
     * - documentation: Код метода вебсервиса ( GET_DICT, UPDATE_DICT )
     * - minOccurs: 1
     * @var string
     */
    public $actionType;
    /**
     * The actionStatus
     * Meta information extracted from the WSDL
     * - documentation: Статус выполнения запроса
     * - minOccurs: 1
     * @var string
     */
    public $actionStatus;
    /**
     * The dictFile
     * Meta information extracted from the WSDL
     * - documentation: бинарные данные zip-архива с данными справочника
     * - minOccurs: 0
     * @var string
     */
    public $dictFile;
    /**
     * The dictId
     * Meta information extracted from the WSDL
     * - documentation: ID справочника (dictionary_type)
     * - minOccurs: 0
     * @var string
     */
    public $dictId;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Версия справочника
     * @var string
     */
    public $version;
    /**
     * Constructor method for CheckActionStateResponse
     * @uses CheckActionStateResponse::setActionType()
     * @uses CheckActionStateResponse::setActionStatus()
     * @uses CheckActionStateResponse::setDictFile()
     * @uses CheckActionStateResponse::setDictId()
     * @uses CheckActionStateResponse::setVersion()
     * @param string $actionType
     * @param string $actionStatus
     * @param string $dictFile
     * @param string $dictId
     * @param string $version
     */
    public function __construct($actionType = null, $actionStatus = null, $dictFile = null, $dictId = null, $version = null)
    {
        $this
            ->setActionType($actionType)
            ->setActionStatus($actionStatus)
            ->setDictFile($dictFile)
            ->setDictId($dictId)
            ->setVersion($version);
    }
    /**
     * Get actionType value
     * @return string
     */
    public function getActionType()
    {
        return $this->actionType;
    }
    /**
     * Set actionType value
     * @param string $actionType
     * @return \StructType\CheckActionStateResponse
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        $this->actionType = $actionType;
        return $this;
    }
    /**
     * Get actionStatus value
     * @return string
     */
    public function getActionStatus()
    {
        return $this->actionStatus;
    }
    /**
     * Set actionStatus value
     * @param string $actionStatus
     * @return \StructType\CheckActionStateResponse
     */
    public function setActionStatus($actionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($actionStatus) && !is_string($actionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionStatus, true), gettype($actionStatus)), __LINE__);
        }
        $this->actionStatus = $actionStatus;
        return $this;
    }
    /**
     * Get dictFile value
     * @return string|null
     */
    public function getDictFile()
    {
        return $this->dictFile;
    }
    /**
     * Set dictFile value
     * @param string $dictFile
     * @return \StructType\CheckActionStateResponse
     */
    public function setDictFile($dictFile = null)
    {
        // validation for constraint: string
        if (!is_null($dictFile) && !is_string($dictFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictFile, true), gettype($dictFile)), __LINE__);
        }
        $this->dictFile = $dictFile;
        return $this;
    }
    /**
     * Get dictId value
     * @return string|null
     */
    public function getDictId()
    {
        return $this->dictId;
    }
    /**
     * Set dictId value
     * @param string $dictId
     * @return \StructType\CheckActionStateResponse
     */
    public function setDictId($dictId = null)
    {
        // validation for constraint: string
        if (!is_null($dictId) && !is_string($dictId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictId, true), gettype($dictId)), __LINE__);
        }
        $this->dictId = $dictId;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\CheckActionStateResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
