<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkState
     * Meta information extracted from the WSDL
     * - documentation: Проверка статуса выполнения запроса.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckActionStateRequest $checkActionStateRequestP
     * @return \StructType\CheckActionStateResponse|bool
     */
    public function checkState(\StructType\CheckActionStateRequest $checkActionStateRequestP)
    {
        try {
            $this->setResult($this->getSoapClient()->checkState($checkActionStateRequestP));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckActionStateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
