<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDictionaryRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Запрос на обновление справочника
 * @subpackage Structs
 */
class UpdateDictionaryRequest extends AbstractStructBase
{
    /**
     * The actionType
     * Meta information extracted from the WSDL
     * - documentation: Код действия над справочником ( UPDATE, DELETE, CREATE )
     * - minOccurs: 1
     * @var string
     */
    public $actionType;
    /**
     * The dictId
     * Meta information extracted from the WSDL
     * - documentation: ID справочника (dictionary_type)
     * - minOccurs: 0
     * @var string
     */
    public $dictId;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Версия справочника
     * @var string
     */
    public $version;
    /**
     * The dictFile
     * Meta information extracted from the WSDL
     * - documentation: бинарные данные zip-архива с обновлениями справочника
     * - minOccurs: 0
     * @var string
     */
    public $dictFile;
    /**
     * Constructor method for UpdateDictionaryRequest
     * @uses UpdateDictionaryRequest::setActionType()
     * @uses UpdateDictionaryRequest::setDictId()
     * @uses UpdateDictionaryRequest::setVersion()
     * @uses UpdateDictionaryRequest::setDictFile()
     * @param string $actionType
     * @param string $dictId
     * @param string $version
     * @param string $dictFile
     */
    public function __construct($actionType = null, $dictId = null, $version = null, $dictFile = null)
    {
        $this
            ->setActionType($actionType)
            ->setDictId($dictId)
            ->setVersion($version)
            ->setDictFile($dictFile);
    }
    /**
     * Get actionType value
     * @return string
     */
    public function getActionType()
    {
        return $this->actionType;
    }
    /**
     * Set actionType value
     * @param string $actionType
     * @return \StructType\UpdateDictionaryRequest
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        $this->actionType = $actionType;
        return $this;
    }
    /**
     * Get dictId value
     * @return string|null
     */
    public function getDictId()
    {
        return $this->dictId;
    }
    /**
     * Set dictId value
     * @param string $dictId
     * @return \StructType\UpdateDictionaryRequest
     */
    public function setDictId($dictId = null)
    {
        // validation for constraint: string
        if (!is_null($dictId) && !is_string($dictId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictId, true), gettype($dictId)), __LINE__);
        }
        $this->dictId = $dictId;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\UpdateDictionaryRequest
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get dictFile value
     * @return string|null
     */
    public function getDictFile()
    {
        return $this->dictFile;
    }
    /**
     * Set dictFile value
     * @param string $dictFile
     * @return \StructType\UpdateDictionaryRequest
     */
    public function setDictFile($dictFile = null)
    {
        // validation for constraint: string
        if (!is_null($dictFile) && !is_string($dictFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictFile, true), gettype($dictFile)), __LINE__);
        }
        $this->dictFile = $dictFile;
        return $this;
    }
}
