<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateDictionary
     * Meta information extracted from the WSDL
     * - documentation: Запрос на обновление справочника.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDictionaryRequest $updateDictionaryRequestP
     * @return \StructType\UpdateDictionaryResponse|bool
     */
    public function updateDictionary(\StructType\UpdateDictionaryRequest $updateDictionaryRequestP)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDictionary($updateDictionaryRequestP));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateDictionaryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
