<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getDictionary
     * Meta information extracted from the WSDL
     * - documentation: Запрос на получение данных справочника.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDictionaryRequest $getDictionaryRequestP
     * @return \StructType\GetDictionaryResponse|bool
     */
    public function getDictionary(\StructType\GetDictionaryRequest $getDictionaryRequestP)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionary($getDictionaryRequestP));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDictionaryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
