<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestReference StructType
 * @subpackage Structs
 */
class RequestReference extends AbstractStructBase
{
    /**
     * The RequestId
     * @var string
     */
    public $RequestId;
    /**
     * Constructor method for RequestReference
     * @uses RequestReference::setRequestId()
     * @param string $requestId
     */
    public function __construct($requestId = null)
    {
        $this
            ->setRequestId($requestId);
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\RequestReference
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
}
