<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidContent StructType
 * Meta information extracted from the WSDL
 * - type: tns:InvalidContent
 * @subpackage Structs
 */
class InvalidContent extends SmevFault
{
    /**
     * The ValidationError
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ValidationError[]
     */
    public $ValidationError;
    /**
     * Constructor method for InvalidContent
     * @uses InvalidContent::setValidationError()
     * @param \StructType\ValidationError[] $validationError
     */
    public function __construct(array $validationError = array())
    {
        $this
            ->setValidationError($validationError);
    }
    /**
     * Get ValidationError value
     * @return \StructType\ValidationError[]|null
     */
    public function getValidationError()
    {
        return $this->ValidationError;
    }
    /**
     * This method is responsible for validating the values passed to the setValidationError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidationError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValidationErrorForArrayConstraintsFromSetValidationError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invalidContentValidationErrorItem) {
            // validation for constraint: itemType
            if (!$invalidContentValidationErrorItem instanceof \StructType\ValidationError) {
                $invalidValues[] = is_object($invalidContentValidationErrorItem) ? get_class($invalidContentValidationErrorItem) : sprintf('%s(%s)', gettype($invalidContentValidationErrorItem), var_export($invalidContentValidationErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValidationError property can only contain items of type \StructType\ValidationError, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValidationError value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationError[] $validationError
     * @return \StructType\InvalidContent
     */
    public function setValidationError(array $validationError = array())
    {
        // validation for constraint: array
        if ('' !== ($validationErrorArrayErrorMessage = self::validateValidationErrorForArrayConstraintsFromSetValidationError($validationError))) {
            throw new \InvalidArgumentException($validationErrorArrayErrorMessage, __LINE__);
        }
        $this->ValidationError = $validationError;
        return $this;
    }
    /**
     * Add item to ValidationError value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationError $item
     * @return \StructType\InvalidContent
     */
    public function addToValidationError(\StructType\ValidationError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidationError) {
            throw new \InvalidArgumentException(sprintf('The ValidationError property can only contain items of type \StructType\ValidationError, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValidationError[] = $item;
        return $this;
    }
}
