<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationError StructType
 * @subpackage Structs
 */
class ValidationError extends AbstractStructBase
{
    /**
     * The errorPosition
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $errorPosition;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for ValidationError
     * @uses ValidationError::setErrorPosition()
     * @uses ValidationError::set_()
     * @param int $errorPosition
     * @param string $_
     */
    public function __construct($errorPosition = null, $_ = null)
    {
        $this
            ->setErrorPosition($errorPosition)
            ->set_($_);
    }
    /**
     * Get errorPosition value
     * @return int
     */
    public function getErrorPosition()
    {
        return $this->errorPosition;
    }
    /**
     * Set errorPosition value
     * @param int $errorPosition
     * @return \StructType\ValidationError
     */
    public function setErrorPosition($errorPosition = null)
    {
        // validation for constraint: int
        if (!is_null($errorPosition) && !(is_int($errorPosition) || ctype_digit($errorPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorPosition, true), gettype($errorPosition)), __LINE__);
        }
        $this->errorPosition = $errorPosition;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ValidationError
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
