<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderProvidedResponseData StructType
 * @subpackage Structs
 */
class SenderProvidedResponseData extends AbstractStructBase
{
    /**
     * The RequestReference
     * Meta information extracted from the WSDL
     * - ref: ns1:RequestReference
     * @var \StructType\RequestReference
     */
    public $RequestReference;
    /**
     * The MessagePrimaryContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns1:MessagePrimaryContent
     * @var \StructType\MessagePrimaryContent
     */
    public $MessagePrimaryContent;
    /**
     * The RequestRejected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RequestRejected
     */
    public $RequestRejected;
    /**
     * Constructor method for SenderProvidedResponseData
     * @uses SenderProvidedResponseData::setRequestReference()
     * @uses SenderProvidedResponseData::setMessagePrimaryContent()
     * @uses SenderProvidedResponseData::setRequestRejected()
     * @param \StructType\RequestReference $requestReference
     * @param \StructType\MessagePrimaryContent $messagePrimaryContent
     * @param \StructType\RequestRejected $requestRejected
     */
    public function __construct(\StructType\RequestReference $requestReference = null, \StructType\MessagePrimaryContent $messagePrimaryContent = null, \StructType\RequestRejected $requestRejected = null)
    {
        $this
            ->setRequestReference($requestReference)
            ->setMessagePrimaryContent($messagePrimaryContent)
            ->setRequestRejected($requestRejected);
    }
    /**
     * Get RequestReference value
     * @return \StructType\RequestReference|null
     */
    public function getRequestReference()
    {
        return $this->RequestReference;
    }
    /**
     * Set RequestReference value
     * @param \StructType\RequestReference $requestReference
     * @return \StructType\SenderProvidedResponseData
     */
    public function setRequestReference(\StructType\RequestReference $requestReference = null)
    {
        $this->RequestReference = $requestReference;
        return $this;
    }
    /**
     * Get MessagePrimaryContent value
     * @return \StructType\MessagePrimaryContent|null
     */
    public function getMessagePrimaryContent()
    {
        return $this->MessagePrimaryContent;
    }
    /**
     * Set MessagePrimaryContent value
     * @param \StructType\MessagePrimaryContent $messagePrimaryContent
     * @return \StructType\SenderProvidedResponseData
     */
    public function setMessagePrimaryContent(\StructType\MessagePrimaryContent $messagePrimaryContent = null)
    {
        $this->MessagePrimaryContent = $messagePrimaryContent;
        return $this;
    }
    /**
     * Get RequestRejected value
     * @return \StructType\RequestRejected|null
     */
    public function getRequestRejected()
    {
        return $this->RequestRejected;
    }
    /**
     * Set RequestRejected value
     * @param \StructType\RequestRejected $requestRejected
     * @return \StructType\SenderProvidedResponseData
     */
    public function setRequestRejected(\StructType\RequestRejected $requestRejected = null)
    {
        $this->RequestRejected = $requestRejected;
        return $this;
    }
}
