<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sender StructType
 * @subpackage Structs
 */
class Sender extends AbstractStructBase
{
    /**
     * The Mnemonic
     * @var string
     */
    public $Mnemonic;
    /**
     * The HumanReadableName
     * @var string
     */
    public $HumanReadableName;
    /**
     * Constructor method for Sender
     * @uses Sender::setMnemonic()
     * @uses Sender::setHumanReadableName()
     * @param string $mnemonic
     * @param string $humanReadableName
     */
    public function __construct($mnemonic = null, $humanReadableName = null)
    {
        $this
            ->setMnemonic($mnemonic)
            ->setHumanReadableName($humanReadableName);
    }
    /**
     * Get Mnemonic value
     * @return string|null
     */
    public function getMnemonic()
    {
        return $this->Mnemonic;
    }
    /**
     * Set Mnemonic value
     * @param string $mnemonic
     * @return \StructType\Sender
     */
    public function setMnemonic($mnemonic = null)
    {
        // validation for constraint: string
        if (!is_null($mnemonic) && !is_string($mnemonic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mnemonic, true), gettype($mnemonic)), __LINE__);
        }
        $this->Mnemonic = $mnemonic;
        return $this;
    }
    /**
     * Get HumanReadableName value
     * @return string|null
     */
    public function getHumanReadableName()
    {
        return $this->HumanReadableName;
    }
    /**
     * Set HumanReadableName value
     * @param string $humanReadableName
     * @return \StructType\Sender
     */
    public function setHumanReadableName($humanReadableName = null)
    {
        // validation for constraint: string
        if (!is_null($humanReadableName) && !is_string($humanReadableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($humanReadableName, true), gettype($humanReadableName)), __LINE__);
        }
        $this->HumanReadableName = $humanReadableName;
        return $this;
    }
}
