<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestRejectedReason StructType
 * @subpackage Structs
 */
class RequestRejectedReason extends AbstractStructBase
{
    /**
     * The RejectionReasonCode
     * @var string
     */
    public $RejectionReasonCode;
    /**
     * The RejectionReasonDescription
     * @var string
     */
    public $RejectionReasonDescription;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * Constructor method for RequestRejectedReason
     * @uses RequestRejectedReason::setRejectionReasonCode()
     * @uses RequestRejectedReason::setRejectionReasonDescription()
     * @uses RequestRejectedReason::setAdditionalInformation()
     * @param string $rejectionReasonCode
     * @param string $rejectionReasonDescription
     * @param \StructType\AdditionalInformation $additionalInformation
     */
    public function __construct($rejectionReasonCode = null, $rejectionReasonDescription = null, \StructType\AdditionalInformation $additionalInformation = null)
    {
        $this
            ->setRejectionReasonCode($rejectionReasonCode)
            ->setRejectionReasonDescription($rejectionReasonDescription)
            ->setAdditionalInformation($additionalInformation);
    }
    /**
     * Get RejectionReasonCode value
     * @return string|null
     */
    public function getRejectionReasonCode()
    {
        return $this->RejectionReasonCode;
    }
    /**
     * Set RejectionReasonCode value
     * @param string $rejectionReasonCode
     * @return \StructType\RequestRejectedReason
     */
    public function setRejectionReasonCode($rejectionReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($rejectionReasonCode) && !is_string($rejectionReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectionReasonCode, true), gettype($rejectionReasonCode)), __LINE__);
        }
        $this->RejectionReasonCode = $rejectionReasonCode;
        return $this;
    }
    /**
     * Get RejectionReasonDescription value
     * @return string|null
     */
    public function getRejectionReasonDescription()
    {
        return $this->RejectionReasonDescription;
    }
    /**
     * Set RejectionReasonDescription value
     * @param string $rejectionReasonDescription
     * @return \StructType\RequestRejectedReason
     */
    public function setRejectionReasonDescription($rejectionReasonDescription = null)
    {
        // validation for constraint: string
        if (!is_null($rejectionReasonDescription) && !is_string($rejectionReasonDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectionReasonDescription, true), gettype($rejectionReasonDescription)), __LINE__);
        }
        $this->RejectionReasonDescription = $rejectionReasonDescription;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \StructType\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \StructType\AdditionalInformation $additionalInformation
     * @return \StructType\RequestRejectedReason
     */
    public function setAdditionalInformation(\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
}
