<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The SenderProvidedResponseData
     * Meta information extracted from the WSDL
     * - ref: tns:SenderProvidedResponseData
     * @var \StructType\SenderProvidedResponseData
     */
    public $SenderProvidedResponseData;
    /**
     * The MessageMetadata
     * Meta information extracted from the WSDL
     * - ref: tns:MessageMetadata
     * @var \StructType\MessageMetadata
     */
    public $MessageMetadata;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Response
     * @uses Response::setSenderProvidedResponseData()
     * @uses Response::setMessageMetadata()
     * @uses Response::setId()
     * @param \StructType\SenderProvidedResponseData $senderProvidedResponseData
     * @param \StructType\MessageMetadata $messageMetadata
     * @param string $id
     */
    public function __construct(\StructType\SenderProvidedResponseData $senderProvidedResponseData = null, \StructType\MessageMetadata $messageMetadata = null, $id = null)
    {
        $this
            ->setSenderProvidedResponseData($senderProvidedResponseData)
            ->setMessageMetadata($messageMetadata)
            ->setId($id);
    }
    /**
     * Get SenderProvidedResponseData value
     * @return \StructType\SenderProvidedResponseData|null
     */
    public function getSenderProvidedResponseData()
    {
        return $this->SenderProvidedResponseData;
    }
    /**
     * Set SenderProvidedResponseData value
     * @param \StructType\SenderProvidedResponseData $senderProvidedResponseData
     * @return \StructType\Response
     */
    public function setSenderProvidedResponseData(\StructType\SenderProvidedResponseData $senderProvidedResponseData = null)
    {
        $this->SenderProvidedResponseData = $senderProvidedResponseData;
        return $this;
    }
    /**
     * Get MessageMetadata value
     * @return \StructType\MessageMetadata|null
     */
    public function getMessageMetadata()
    {
        return $this->MessageMetadata;
    }
    /**
     * Set MessageMetadata value
     * @param \StructType\MessageMetadata $messageMetadata
     * @return \StructType\Response
     */
    public function setMessageMetadata(\StructType\MessageMetadata $messageMetadata = null)
    {
        $this->MessageMetadata = $messageMetadata;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Response
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
