<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageMetadata StructType
 * @subpackage Structs
 */
class MessageMetadata extends AbstractStructBase
{
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestId;
    /**
     * The SendingTimestamp
     * @var string
     */
    public $SendingTimestamp;
    /**
     * The DeliveryTimestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTimestamp;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for MessageMetadata
     * @uses MessageMetadata::setRequestId()
     * @uses MessageMetadata::setSendingTimestamp()
     * @uses MessageMetadata::setDeliveryTimestamp()
     * @uses MessageMetadata::setStatus()
     * @param string $requestId
     * @param string $sendingTimestamp
     * @param string $deliveryTimestamp
     * @param string $status
     */
    public function __construct($requestId = null, $sendingTimestamp = null, $deliveryTimestamp = null, $status = null)
    {
        $this
            ->setRequestId($requestId)
            ->setSendingTimestamp($sendingTimestamp)
            ->setDeliveryTimestamp($deliveryTimestamp)
            ->setStatus($status);
    }
    /**
     * Get RequestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param string $requestId
     * @return \StructType\MessageMetadata
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get SendingTimestamp value
     * @return string|null
     */
    public function getSendingTimestamp()
    {
        return $this->SendingTimestamp;
    }
    /**
     * Set SendingTimestamp value
     * @param string $sendingTimestamp
     * @return \StructType\MessageMetadata
     */
    public function setSendingTimestamp($sendingTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($sendingTimestamp) && !is_string($sendingTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendingTimestamp, true), gettype($sendingTimestamp)), __LINE__);
        }
        $this->SendingTimestamp = $sendingTimestamp;
        return $this;
    }
    /**
     * Get DeliveryTimestamp value
     * @return string|null
     */
    public function getDeliveryTimestamp()
    {
        return $this->DeliveryTimestamp;
    }
    /**
     * Set DeliveryTimestamp value
     * @param string $deliveryTimestamp
     * @return \StructType\MessageMetadata
     */
    public function setDeliveryTimestamp($deliveryTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimestamp) && !is_string($deliveryTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimestamp, true), gettype($deliveryTimestamp)), __LINE__);
        }
        $this->DeliveryTimestamp = $deliveryTimestamp;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\MessageMetadata
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
