<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInformation StructType
 * @subpackage Structs
 */
class AdditionalInformation extends AbstractStructBase
{
    /**
     * The TravelerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelerId;
    /**
     * The ServiceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceId;
    /**
     * The TourAgentEFRTARegNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TourAgentEFRTARegNumber;
    /**
     * The PartnerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartnerCode;
    /**
     * The ReceivedValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReceivedValue;
    /**
     * Constructor method for AdditionalInformation
     * @uses AdditionalInformation::setTravelerId()
     * @uses AdditionalInformation::setServiceId()
     * @uses AdditionalInformation::setTourAgentEFRTARegNumber()
     * @uses AdditionalInformation::setPartnerCode()
     * @uses AdditionalInformation::setReceivedValue()
     * @param string $travelerId
     * @param string $serviceId
     * @param string $tourAgentEFRTARegNumber
     * @param string $partnerCode
     * @param string $receivedValue
     */
    public function __construct($travelerId = null, $serviceId = null, $tourAgentEFRTARegNumber = null, $partnerCode = null, $receivedValue = null)
    {
        $this
            ->setTravelerId($travelerId)
            ->setServiceId($serviceId)
            ->setTourAgentEFRTARegNumber($tourAgentEFRTARegNumber)
            ->setPartnerCode($partnerCode)
            ->setReceivedValue($receivedValue);
    }
    /**
     * Get TravelerId value
     * @return string|null
     */
    public function getTravelerId()
    {
        return $this->TravelerId;
    }
    /**
     * Set TravelerId value
     * @param string $travelerId
     * @return \StructType\AdditionalInformation
     */
    public function setTravelerId($travelerId = null)
    {
        // validation for constraint: string
        if (!is_null($travelerId) && !is_string($travelerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerId, true), gettype($travelerId)), __LINE__);
        }
        $this->TravelerId = $travelerId;
        return $this;
    }
    /**
     * Get ServiceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }
    /**
     * Set ServiceId value
     * @param string $serviceId
     * @return \StructType\AdditionalInformation
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->ServiceId = $serviceId;
        return $this;
    }
    /**
     * Get TourAgentEFRTARegNumber value
     * @return string|null
     */
    public function getTourAgentEFRTARegNumber()
    {
        return $this->TourAgentEFRTARegNumber;
    }
    /**
     * Set TourAgentEFRTARegNumber value
     * @param string $tourAgentEFRTARegNumber
     * @return \StructType\AdditionalInformation
     */
    public function setTourAgentEFRTARegNumber($tourAgentEFRTARegNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tourAgentEFRTARegNumber) && !is_string($tourAgentEFRTARegNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourAgentEFRTARegNumber, true), gettype($tourAgentEFRTARegNumber)), __LINE__);
        }
        $this->TourAgentEFRTARegNumber = $tourAgentEFRTARegNumber;
        return $this;
    }
    /**
     * Get PartnerCode value
     * @return string|null
     */
    public function getPartnerCode()
    {
        return $this->PartnerCode;
    }
    /**
     * Set PartnerCode value
     * @param string $partnerCode
     * @return \StructType\AdditionalInformation
     */
    public function setPartnerCode($partnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCode) && !is_string($partnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerCode, true), gettype($partnerCode)), __LINE__);
        }
        $this->PartnerCode = $partnerCode;
        return $this;
    }
    /**
     * Get ReceivedValue value
     * @return string|null
     */
    public function getReceivedValue()
    {
        return $this->ReceivedValue;
    }
    /**
     * Set ReceivedValue value
     * @param string $receivedValue
     * @return \StructType\AdditionalInformation
     */
    public function setReceivedValue($receivedValue = null)
    {
        // validation for constraint: string
        if (!is_null($receivedValue) && !is_string($receivedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedValue, true), gettype($receivedValue)), __LINE__);
        }
        $this->ReceivedValue = $receivedValue;
        return $this;
    }
}
