<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'BusinessDataTypeIsNotSupported' => '\\StructType\\BusinessDataTypeIsNotSupported',
            'InvalidContent' => '\\StructType\\InvalidContent',
            'ValidationError' => '\\StructType\\ValidationError',
            'MessagePrimaryContent' => '\\StructType\\MessagePrimaryContent',
            'MessageReference' => '\\StructType\\MessageReference',
            'RequestReference' => '\\StructType\\RequestReference',
            'Timestamp' => '\\StructType\\Timestamp',
            'Void' => '\\StructType\\_Void',
            'SmevFault' => '\\StructType\\SmevFault',
            'GetResponseRequest' => '\\StructType\\GetResponseRequest',
            'GetResponseResponse' => '\\StructType\\GetResponseResponse',
            'ResponseMessage' => '\\StructType\\ResponseMessage',
            'MessageMetadata' => '\\StructType\\MessageMetadata',
            'Response' => '\\StructType\\Response',
            'SendRequestRequest' => '\\StructType\\SendRequestRequest',
            'SendRequestResponse' => '\\StructType\\SendRequestResponse',
            'Sender' => '\\StructType\\Sender',
            'SenderProvidedGetResponseData' => '\\StructType\\SenderProvidedGetResponseData',
            'SenderProvidedRequestData' => '\\StructType\\SenderProvidedRequestData',
            'SenderProvidedResponseData' => '\\StructType\\SenderProvidedResponseData',
            'RequestRejected' => '\\StructType\\RequestRejected',
            'RequestRejectedReason' => '\\StructType\\RequestRejectedReason',
            'AdditionalInformation' => '\\StructType\\AdditionalInformation',
            'GetResponse' => '\\StructType\\GetResponse',
            'SendRequest' => '\\StructType\\SendRequest',
        );
    }
}
